/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.app;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppStartUpService;
import com.crosspaste.config.DesktopAppConfig;
import com.crosspaste.config.DesktopConfigManager;
import com.crosspaste.path.AppPathProvider;
import com.crosspaste.presist.FilePersist;
import com.crosspaste.utils.SystemProperty_desktop_ktKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\nJ\u000f\u0010\u000f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/crosspaste/app/MacAppStartUpService;", "Lcom/crosspaste/app/AppStartUpService;", "Lcom/crosspaste/config/DesktopConfigManager;", "configManager", "Lcom/crosspaste/path/AppPathProvider;", "appPathProvider", "<init>", "(Lcom/crosspaste/config/DesktopConfigManager;Lcom/crosspaste/path/AppPathProvider;)V", "", "followConfig", "()V", "", "isAutoStartUp", "()Z", "makeAutoStartUp", "removeAutoStartUp", "Lcom/crosspaste/config/DesktopConfigManager;", "Lcom/crosspaste/path/AppPathProvider;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "", "crosspasteBundleID", "Ljava/lang/String;", "plist", "Lcom/crosspaste/presist/FilePersist;", "filePersist", "Lcom/crosspaste/presist/FilePersist;", "app"})
@StabilityInferred(parameters=0)
public final class MacAppStartUpService
implements AppStartUpService {
    @NotNull
    private final DesktopConfigManager configManager;
    @NotNull
    private final AppPathProvider appPathProvider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String crosspasteBundleID;
    @NotNull
    private final String plist;
    @NotNull
    private final FilePersist filePersist;
    public static final int $stable = 8;

    public MacAppStartUpService(@NotNull DesktopConfigManager configManager, @NotNull AppPathProvider appPathProvider) {
        Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
        Intrinsics.checkNotNullParameter((Object)appPathProvider, (String)"appPathProvider");
        this.configManager = configManager;
        this.appPathProvider = appPathProvider;
        this.logger = KotlinLogging.INSTANCE.logger(MacAppStartUpService::logger$lambda$0);
        this.crosspasteBundleID = SystemProperty_desktop_ktKt.getSystemProperty().get("mac.bundleID");
        this.plist = this.crosspasteBundleID + ".plist";
        this.filePersist = FilePersist.INSTANCE;
    }

    @Override
    public void followConfig() {
        if (((DesktopAppConfig)this.configManager.getCurrentConfig()).getEnableAutoStartUp()) {
            this.makeAutoStartUp();
        } else {
            this.removeAutoStartUp();
        }
    }

    @Override
    public boolean isAutoStartUp() {
        return Path.resolve$default((Path)this.appPathProvider.getUserHome(), (String)("Library/LaunchAgents/" + this.plist), (boolean)false, (int)2, null).toFile().exists();
    }

    @Override
    public void makeAutoStartUp() {
        block3: {
            Object object;
            Object object2 = this;
            try {
                MacAppStartUpService $this$makeAutoStartUp_u24lambda_u242 = object2;
                boolean bl = false;
                if (!$this$makeAutoStartUp_u24lambda_u242.isAutoStartUp()) {
                    $this$makeAutoStartUp_u24lambda_u242.logger.info(MacAppStartUpService::makeAutoStartUp$lambda$2$lambda$1);
                    Path plistPath = Path.resolve$default((Path)$this$makeAutoStartUp_u24lambda_u242.appPathProvider.getUserHome(), (String)("Library/LaunchAgents/" + $this$makeAutoStartUp_u24lambda_u242.plist), (boolean)false, (int)2, null);
                    $this$makeAutoStartUp_u24lambda_u242.filePersist.createOneFilePersist(plistPath).saveBytes(StringsKt.encodeToByteArray((String)StringsKt.trimIndent((String)("\n                        <?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                        <!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n                        <plist version=\"1.0\">\n                        <dict>\n                            <key>Label</key>\n                            <string>" + $this$makeAutoStartUp_u24lambda_u242.crosspasteBundleID + "</string>\n                            <key>ProgramArguments</key>\n                            <array>\n                                <string>" + Path.resolve$default((Path)$this$makeAutoStartUp_u24lambda_u242.appPathProvider.getPasteAppPath(), (String)"Contents/MacOS/CrossPaste", (boolean)false, (int)2, null) + "</string>\n                                <string>--minimize</string>\n                            </array>\n                            <key>RunAtLoad</key>\n                            <true/>\n                        </dict>\n                        </plist>\n                        "))));
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object e = object = throwable;
            boolean bl = false;
            this.logger.error((Throwable)e, MacAppStartUpService::makeAutoStartUp$lambda$4$lambda$3);
        }
    }

    @Override
    public void removeAutoStartUp() {
        block3: {
            Object object;
            Object object2 = this;
            try {
                MacAppStartUpService $this$removeAutoStartUp_u24lambda_u246 = object2;
                boolean bl = false;
                if ($this$removeAutoStartUp_u24lambda_u246.isAutoStartUp()) {
                    $this$removeAutoStartUp_u24lambda_u246.logger.info(MacAppStartUpService::removeAutoStartUp$lambda$6$lambda$5);
                    Path.resolve$default((Path)$this$removeAutoStartUp_u24lambda_u246.appPathProvider.getUserHome(), (String)("Library/LaunchAgents/" + $this$removeAutoStartUp_u24lambda_u246.plist), (boolean)false, (int)2, null).toFile().delete();
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object e = object = throwable;
            boolean bl = false;
            this.logger.error((Throwable)e, MacAppStartUpService::removeAutoStartUp$lambda$8$lambda$7);
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object makeAutoStartUp$lambda$2$lambda$1() {
        return "Make auto startup";
    }

    private static final Object makeAutoStartUp$lambda$4$lambda$3() {
        return "Failed to make auto startup";
    }

    private static final Object removeAutoStartUp$lambda$6$lambda$5() {
        return "Remove auto startup";
    }

    private static final Object removeAutoStartUp$lambda$8$lambda$7() {
        return "Failed to remove auto startup";
    }
}

