/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.app;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppStartUpService;
import com.crosspaste.config.DesktopAppConfig;
import com.crosspaste.config.DesktopConfigManager;
import com.crosspaste.path.AppPathProvider;
import com.crosspaste.presist.FilePersist;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\nJ\u000f\u0010\u000f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/crosspaste/app/LinuxAppStartUpService;", "Lcom/crosspaste/app/AppStartUpService;", "Lcom/crosspaste/path/AppPathProvider;", "appPathProvider", "Lcom/crosspaste/config/DesktopConfigManager;", "configManager", "<init>", "(Lcom/crosspaste/path/AppPathProvider;Lcom/crosspaste/config/DesktopConfigManager;)V", "", "followConfig", "()V", "", "isAutoStartUp", "()Z", "makeAutoStartUp", "removeAutoStartUp", "Lcom/crosspaste/path/AppPathProvider;", "Lcom/crosspaste/config/DesktopConfigManager;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "", "desktopFile", "Ljava/lang/String;", "Lcom/crosspaste/presist/FilePersist;", "filePersist", "Lcom/crosspaste/presist/FilePersist;", "Lokio/Path;", "appExePath", "Lokio/Path;", "app"})
@StabilityInferred(parameters=0)
public final class LinuxAppStartUpService
implements AppStartUpService {
    @NotNull
    private final AppPathProvider appPathProvider;
    @NotNull
    private final DesktopConfigManager configManager;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String desktopFile;
    @NotNull
    private final FilePersist filePersist;
    @NotNull
    private final Path appExePath;
    public static final int $stable = 8;

    public LinuxAppStartUpService(@NotNull AppPathProvider appPathProvider, @NotNull DesktopConfigManager configManager) {
        Intrinsics.checkNotNullParameter((Object)appPathProvider, (String)"appPathProvider");
        Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
        this.appPathProvider = appPathProvider;
        this.configManager = configManager;
        this.logger = KotlinLogging.INSTANCE.logger(LinuxAppStartUpService::logger$lambda$0);
        this.desktopFile = "crosspaste.desktop";
        this.filePersist = FilePersist.INSTANCE;
        this.appExePath = Path.resolve$default((Path)Path.resolve$default((Path)this.appPathProvider.getPasteAppPath(), (String)"bin", (boolean)false, (int)2, null), (String)"crosspaste", (boolean)false, (int)2, null);
    }

    @Override
    public void followConfig() {
        if (((DesktopAppConfig)this.configManager.getCurrentConfig()).getEnableAutoStartUp()) {
            this.makeAutoStartUp();
        } else {
            this.removeAutoStartUp();
        }
    }

    @Override
    public boolean isAutoStartUp() {
        return Path.resolve$default((Path)this.appPathProvider.getUserHome(), (String)(".config/autostart/" + this.desktopFile), (boolean)false, (int)2, null).toFile().exists();
    }

    @Override
    public void makeAutoStartUp() {
        block3: {
            Object object;
            Object object2 = this;
            try {
                LinuxAppStartUpService $this$makeAutoStartUp_u24lambda_u242 = object2;
                boolean bl = false;
                if (!$this$makeAutoStartUp_u24lambda_u242.isAutoStartUp()) {
                    $this$makeAutoStartUp_u24lambda_u242.logger.info(LinuxAppStartUpService::makeAutoStartUp$lambda$2$lambda$1);
                    Path desktopFilePath = Path.resolve$default((Path)$this$makeAutoStartUp_u24lambda_u242.appPathProvider.getUserHome(), (String)(".config/autostart/" + $this$makeAutoStartUp_u24lambda_u242.desktopFile), (boolean)false, (int)2, null);
                    $this$makeAutoStartUp_u24lambda_u242.filePersist.createOneFilePersist(desktopFilePath).saveBytes(StringsKt.encodeToByteArray((String)StringsKt.trimIndent((String)("\n                        [Desktop Entry]\n                        Type=Application\n                        Name=CrossPaste\n                        Exec=" + $this$makeAutoStartUp_u24lambda_u242.appExePath + " --minimize\n                        Categories=Utility\n                        Terminal=false\n                        X-GNOME-Autostart-enabled=true\n                        X-GNOME-Autostart-Delay=10\n                        X-MATE-Autostart-Delay=10\n                        X-KDE-autostart-after=panel\n                        "))));
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object e = object = throwable;
            boolean bl = false;
            this.logger.error((Throwable)e, LinuxAppStartUpService::makeAutoStartUp$lambda$4$lambda$3);
        }
    }

    @Override
    public void removeAutoStartUp() {
        try {
            if (this.isAutoStartUp()) {
                this.logger.info(LinuxAppStartUpService::removeAutoStartUp$lambda$5);
                Path.resolve$default((Path)this.appPathProvider.getUserHome(), (String)(".config/autostart/" + this.desktopFile), (boolean)false, (int)2, null).toFile().delete();
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, LinuxAppStartUpService::removeAutoStartUp$lambda$6);
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object makeAutoStartUp$lambda$2$lambda$1() {
        return "Make auto startup";
    }

    private static final Object makeAutoStartUp$lambda$4$lambda$3() {
        return "Failed to make auto startup";
    }

    private static final Object removeAutoStartUp$lambda$5() {
        return "Remove auto startup";
    }

    private static final Object removeAutoStartUp$lambda$6() {
        return "Failed to remove auto startup";
    }
}

