/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.app;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.db.sync.HostInfo;
import com.crosspaste.dto.sync.EndpointInfo;
import com.crosspaste.net.Server;
import com.crosspaste.platform.Platform;
import com.crosspaste.utils.DeviceUtils;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000f\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0011R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/crosspaste/app/EndpointInfoFactory;", "", "Lcom/crosspaste/utils/DeviceUtils;", "deviceUtils", "Lkotlin/Lazy;", "Lcom/crosspaste/net/Server;", "pasteServer", "Lcom/crosspaste/platform/Platform;", "platform", "<init>", "(Lcom/crosspaste/utils/DeviceUtils;Lkotlin/Lazy;Lcom/crosspaste/platform/Platform;)V", "", "Lcom/crosspaste/db/sync/HostInfo;", "hostInfoList", "Lcom/crosspaste/dto/sync/EndpointInfo;", "createEndpointInfo", "(Ljava/util/List;)Lcom/crosspaste/dto/sync/EndpointInfo;", "Lkotlin/Lazy;", "Lcom/crosspaste/platform/Platform;", "", "deviceName", "Ljava/lang/String;", "deviceId", "app"})
@StabilityInferred(parameters=0)
public final class EndpointInfoFactory {
    @NotNull
    private final Lazy<Server> pasteServer;
    @NotNull
    private final Platform platform;
    @NotNull
    private final String deviceName;
    @NotNull
    private final String deviceId;
    public static final int $stable = 8;

    public EndpointInfoFactory(@NotNull DeviceUtils deviceUtils, @NotNull Lazy<? extends Server> pasteServer, @NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)deviceUtils, (String)"deviceUtils");
        Intrinsics.checkNotNullParameter(pasteServer, (String)"pasteServer");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.pasteServer = pasteServer;
        this.platform = platform;
        this.deviceName = deviceUtils.getDeviceName();
        this.deviceId = deviceUtils.getDeviceId();
    }

    @NotNull
    public final EndpointInfo createEndpointInfo(@NotNull List<HostInfo> hostInfoList) {
        Intrinsics.checkNotNullParameter(hostInfoList, (String)"hostInfoList");
        int port = ((Server)this.pasteServer.getValue()).port();
        return new EndpointInfo(this.deviceId, this.deviceName, this.platform, hostInfoList, port);
    }
}

