/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.app;

import com.crosspaste.app.DesktopAppSize;
import com.crosspaste.app.DesktopAppWindowManager;
import com.crosspaste.app.LinuxAppWindowManager;
import com.crosspaste.app.MacAppWindowManager;
import com.crosspaste.app.WinAppWindowManager;
import com.crosspaste.config.DesktopConfigManager;
import com.crosspaste.listener.ShortcutKeys;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.platform.Platform;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a;\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/crosspaste/app/DesktopAppSize;", "appSize", "Lcom/crosspaste/config/DesktopConfigManager;", "configManager", "Lkotlin/Lazy;", "Lcom/crosspaste/listener/ShortcutKeys;", "lazyShortcutKeys", "Lcom/crosspaste/platform/Platform;", "platform", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "Lcom/crosspaste/app/DesktopAppWindowManager;", "getDesktopAppWindowManager", "(Lcom/crosspaste/app/DesktopAppSize;Lcom/crosspaste/config/DesktopConfigManager;Lkotlin/Lazy;Lcom/crosspaste/platform/Platform;Lcom/crosspaste/path/UserDataPathProvider;)Lcom/crosspaste/app/DesktopAppWindowManager;", "app"})
public final class DesktopAppWindowManagerKt {
    @NotNull
    public static final DesktopAppWindowManager getDesktopAppWindowManager(@NotNull DesktopAppSize appSize, @NotNull DesktopConfigManager configManager, @NotNull Lazy<? extends ShortcutKeys> lazyShortcutKeys, @NotNull Platform platform, @NotNull UserDataPathProvider userDataPathProvider) {
        DesktopAppWindowManager desktopAppWindowManager;
        Intrinsics.checkNotNullParameter((Object)appSize, (String)"appSize");
        Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
        Intrinsics.checkNotNullParameter(lazyShortcutKeys, (String)"lazyShortcutKeys");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        if (platform.isMacos()) {
            desktopAppWindowManager = new MacAppWindowManager(appSize, configManager, lazyShortcutKeys, userDataPathProvider);
        } else if (platform.isWindows()) {
            desktopAppWindowManager = new WinAppWindowManager(appSize, configManager, lazyShortcutKeys, userDataPathProvider);
        } else if (platform.isLinux()) {
            desktopAppWindowManager = new LinuxAppWindowManager(appSize, configManager, lazyShortcutKeys, userDataPathProvider);
        } else {
            throw new IllegalStateException("Unsupported platform: " + platform);
        }
        return desktopAppWindowManager;
    }
}

