/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.app;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppStartUpService;
import com.crosspaste.app.DesktopAppLaunchState;
import com.crosspaste.app.LinuxAppStartUpService;
import com.crosspaste.app.MacAppStartUpService;
import com.crosspaste.app.WindowsAppStartUpService;
import com.crosspaste.config.DesktopConfigManager;
import com.crosspaste.path.AppPathProvider;
import com.crosspaste.platform.Platform;
import com.crosspaste.utils.AppEnvUtils;
import com.crosspaste.utils.AppEnvUtils_desktopKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u000f\u0010\u0013\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/crosspaste/app/DesktopAppStartUpService;", "Lcom/crosspaste/app/AppStartUpService;", "Lcom/crosspaste/app/DesktopAppLaunchState;", "appLaunchState", "Lcom/crosspaste/path/AppPathProvider;", "appPathProvider", "Lcom/crosspaste/config/DesktopConfigManager;", "configManager", "Lcom/crosspaste/platform/Platform;", "platform", "<init>", "(Lcom/crosspaste/app/DesktopAppLaunchState;Lcom/crosspaste/path/AppPathProvider;Lcom/crosspaste/config/DesktopConfigManager;Lcom/crosspaste/platform/Platform;)V", "", "followConfig", "()V", "", "isAutoStartUp", "()Z", "makeAutoStartUp", "removeAutoStartUp", "Lcom/crosspaste/utils/AppEnvUtils;", "appEnvUtils", "Lcom/crosspaste/utils/AppEnvUtils;", "isProduction", "Z", "appStartUpService", "Lcom/crosspaste/app/AppStartUpService;", "app"})
@StabilityInferred(parameters=1)
public final class DesktopAppStartUpService
implements AppStartUpService {
    @NotNull
    private final AppEnvUtils appEnvUtils;
    private final boolean isProduction;
    @NotNull
    private final AppStartUpService appStartUpService;
    public static final int $stable;

    public DesktopAppStartUpService(@NotNull DesktopAppLaunchState appLaunchState, @NotNull AppPathProvider appPathProvider, @NotNull DesktopConfigManager configManager, @NotNull Platform platform) {
        AppStartUpService appStartUpService;
        Intrinsics.checkNotNullParameter((Object)appLaunchState, (String)"appLaunchState");
        Intrinsics.checkNotNullParameter((Object)appPathProvider, (String)"appPathProvider");
        Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.appEnvUtils = AppEnvUtils_desktopKt.getAppEnvUtils();
        this.isProduction = this.appEnvUtils.isProduction();
        if (platform.isMacos()) {
            appStartUpService = new MacAppStartUpService(configManager, appPathProvider);
        } else if (platform.isWindows()) {
            appStartUpService = new WindowsAppStartUpService(appLaunchState, appPathProvider, configManager);
        } else if (platform.isLinux()) {
            appStartUpService = new LinuxAppStartUpService(appPathProvider, configManager);
        } else {
            throw new IllegalStateException("Unsupported platform: " + platform);
        }
        this.appStartUpService = appStartUpService;
    }

    @Override
    public void followConfig() {
        if (this.isProduction) {
            this.appStartUpService.followConfig();
        }
    }

    @Override
    public boolean isAutoStartUp() {
        return this.isProduction ? this.appStartUpService.isAutoStartUp() : false;
    }

    @Override
    public void makeAutoStartUp() {
        if (this.isProduction) {
            this.appStartUpService.makeAutoStartUp();
        }
    }

    @Override
    public void removeAutoStartUp() {
        if (this.isProduction) {
            this.appStartUpService.removeAutoStartUp();
        }
    }
}

