/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.app;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppRestartService;
import com.crosspaste.app.LinuxAppRestartService;
import com.crosspaste.app.MacAppRestartService;
import com.crosspaste.app.WindowsAppRestartService;
import com.crosspaste.path.AppPathProvider;
import com.crosspaste.platform.Platform;
import com.crosspaste.utils.AppEnvUtils;
import com.crosspaste.utils.AppEnvUtils_desktopKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u000b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/crosspaste/app/DesktopAppRestartService;", "Lcom/crosspaste/app/AppRestartService;", "Lcom/crosspaste/platform/Platform;", "platform", "Lcom/crosspaste/path/AppPathProvider;", "appPathProvider", "<init>", "(Lcom/crosspaste/platform/Platform;Lcom/crosspaste/path/AppPathProvider;)V", "Lkotlin/Function0;", "", "exitApplication", "restart", "(Lkotlin/jvm/functions/Function0;)V", "Lcom/crosspaste/utils/AppEnvUtils;", "appEnvUtils", "Lcom/crosspaste/utils/AppEnvUtils;", "appRestartService", "Lcom/crosspaste/app/AppRestartService;", "app"})
@StabilityInferred(parameters=1)
public final class DesktopAppRestartService
implements AppRestartService {
    @NotNull
    private final AppEnvUtils appEnvUtils;
    @NotNull
    private final AppRestartService appRestartService;
    public static final int $stable;

    public DesktopAppRestartService(@NotNull Platform platform, @NotNull AppPathProvider appPathProvider) {
        AppRestartService appRestartService;
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)appPathProvider, (String)"appPathProvider");
        this.appEnvUtils = AppEnvUtils_desktopKt.getAppEnvUtils();
        if (platform.isMacos()) {
            appRestartService = new MacAppRestartService(appPathProvider);
        } else if (platform.isWindows()) {
            appRestartService = new WindowsAppRestartService(appPathProvider);
        } else if (platform.isLinux()) {
            appRestartService = new LinuxAppRestartService(appPathProvider);
        } else {
            throw new IllegalStateException("Unsupported platform: " + platform);
        }
        this.appRestartService = appRestartService;
    }

    @Override
    public void restart(@NotNull Function0<Unit> exitApplication2) {
        Intrinsics.checkNotNullParameter(exitApplication2, (String)"exitApplication");
        if (this.appEnvUtils.isProduction()) {
            this.appRestartService.restart(exitApplication2);
        } else {
            exitApplication2.invoke();
        }
    }
}

