/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.app;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppLaunch;
import com.crosspaste.app.AppLaunchState;
import com.crosspaste.app.AppLock;
import com.crosspaste.app.AppLockState;
import com.crosspaste.app.DesktopAppLaunchState;
import com.crosspaste.app.GeneralAppLockState;
import com.crosspaste.path.AppPathProvider;
import com.crosspaste.platform.Platform;
import com.crosspaste.platform.macos.MacAppUtils;
import com.crosspaste.platform.windows.api.User32;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0017R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f8\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010 \u001a\u0004\b!\u0010\"R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010\u001eR \u0010%\u001a\b\u0012\u0004\u0012\u00020#0\u001f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b%\u0010 \u001a\u0004\b&\u0010\"R\u0018\u0010(\u001a\u0004\u0018\u00010'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0018\u0010+\u001a\u0004\u0018\u00010*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0016\u0010-\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lcom/crosspaste/app/DesktopAppLaunch;", "Lcom/crosspaste/app/AppLaunch;", "Lcom/crosspaste/app/AppLock;", "Lcom/crosspaste/platform/Platform;", "platform", "Lcom/crosspaste/path/AppPathProvider;", "appPathProvider", "<init>", "(Lcom/crosspaste/platform/Platform;Lcom/crosspaste/path/AppPathProvider;)V", "Lcom/crosspaste/app/AppLockState;", "acquireLock", "()Lcom/crosspaste/app/AppLockState;", "", "releaseLock", "()V", "resetFirstLaunchFlag", "Lcom/crosspaste/app/DesktopAppLaunchState;", "launch", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "firstLaunchCompleted", "setFirstLaunchCompleted", "(Z)V", "Lcom/crosspaste/platform/Platform;", "Lcom/crosspaste/path/AppPathProvider;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Lkotlinx/coroutines/flow/MutableStateFlow;", "_firstLaunchCompleted", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lkotlinx/coroutines/flow/StateFlow;", "Lkotlinx/coroutines/flow/StateFlow;", "getFirstLaunchCompleted", "()Lkotlinx/coroutines/flow/StateFlow;", "Lcom/crosspaste/app/AppLaunchState;", "_appLaunchState", "appLaunchState", "getAppLaunchState", "Ljava/nio/channels/FileChannel;", "channel", "Ljava/nio/channels/FileChannel;", "Ljava/nio/channels/FileLock;", "lock", "Ljava/nio/channels/FileLock;", "resetLock", "Z", "app"})
@StabilityInferred(parameters=0)
public final class DesktopAppLaunch
implements AppLaunch,
AppLock {
    @NotNull
    private final Platform platform;
    @NotNull
    private final AppPathProvider appPathProvider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final MutableStateFlow<Boolean> _firstLaunchCompleted;
    @NotNull
    private final StateFlow<Boolean> firstLaunchCompleted;
    @NotNull
    private final MutableStateFlow<AppLaunchState> _appLaunchState;
    @NotNull
    private final StateFlow<AppLaunchState> appLaunchState;
    @Nullable
    private FileChannel channel;
    @Nullable
    private FileLock lock;
    private boolean resetLock;
    public static final int $stable = 8;

    public DesktopAppLaunch(@NotNull Platform platform, @NotNull AppPathProvider appPathProvider) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)appPathProvider, (String)"appPathProvider");
        this.platform = platform;
        this.appPathProvider = appPathProvider;
        this.logger = KotlinLogging.INSTANCE.logger(DesktopAppLaunch::logger$lambda$0);
        this._firstLaunchCompleted = StateFlowKt.MutableStateFlow((Object)false);
        this.firstLaunchCompleted = (StateFlow)this._firstLaunchCompleted;
        this._appLaunchState = StateFlowKt.MutableStateFlow((Object)new DesktopAppLaunchState(-1L, false, false, false, null));
        this.appLaunchState = (StateFlow)this._appLaunchState;
    }

    @NotNull
    public final StateFlow<Boolean> getFirstLaunchCompleted() {
        return this.firstLaunchCompleted;
    }

    @Override
    @NotNull
    public StateFlow<AppLaunchState> getAppLaunchState() {
        return this.appLaunchState;
    }

    @Override
    @NotNull
    public AppLockState acquireLock() {
        Object object;
        Object $this$acquireLock_u24lambda_u243;
        File appLock = Path.resolve$default((Path)this.appPathProvider.getPasteUserPath(), (String)"app.lock", (boolean)false, (int)2, null).toFile();
        boolean firstLaunch = !appLock.exists();
        Object object2 = this;
        try {
            GeneralAppLockState generalAppLockState;
            $this$acquireLock_u24lambda_u243 = object2;
            boolean bl = false;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            FileChannel fileChannel = ((DesktopAppLaunch)$this$acquireLock_u24lambda_u243).channel = FileChannel.open(appLock.toPath(), openOptionArray);
            FileLock fileLock = ((DesktopAppLaunch)$this$acquireLock_u24lambda_u243).lock = fileChannel != null ? fileChannel.tryLock() : null;
            if (((DesktopAppLaunch)$this$acquireLock_u24lambda_u243).lock == null) {
                FileChannel fileChannel2 = ((DesktopAppLaunch)$this$acquireLock_u24lambda_u243).channel;
                if (fileChannel2 != null) {
                    fileChannel2.close();
                }
                ((DesktopAppLaunch)$this$acquireLock_u24lambda_u243).logger.error(DesktopAppLaunch::acquireLock$lambda$3$lambda$1);
                generalAppLockState = new GeneralAppLockState(false, firstLaunch);
            } else {
                ((DesktopAppLaunch)$this$acquireLock_u24lambda_u243).logger.info(DesktopAppLaunch::acquireLock$lambda$3$lambda$2);
                generalAppLockState = new GeneralAppLockState(true, firstLaunch);
            }
            $this$acquireLock_u24lambda_u243 = Result.constructor-impl((Object)generalAppLockState);
        }
        catch (Throwable bl) {
            $this$acquireLock_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$acquireLock_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            if (e instanceof OverlappingFileLockException) {
                this.logger.error(e, DesktopAppLaunch::acquireLock$lambda$6$lambda$4);
                object = new GeneralAppLockState(false, firstLaunch);
            } else {
                this.logger.error(DesktopAppLaunch::acquireLock$lambda$6$lambda$5);
                object = new GeneralAppLockState(false, firstLaunch);
            }
        }
        return (AppLockState)object;
    }

    @Override
    public void releaseLock() {
        block6: {
            Object object;
            Object object2 = this;
            try {
                DesktopAppLaunch $this$releaseLock_u24lambda_u249 = object2;
                boolean bl = false;
                FileLock fileLock = $this$releaseLock_u24lambda_u249.lock;
                if (fileLock != null) {
                    fileLock.release();
                }
                FileChannel fileChannel = $this$releaseLock_u24lambda_u249.channel;
                if (fileChannel != null) {
                    fileChannel.close();
                }
                if ($this$releaseLock_u24lambda_u249.resetLock) {
                    Path.resolve$default((Path)$this$releaseLock_u24lambda_u249.appPathProvider.getPasteUserPath(), (String)"app.lock", (boolean)false, (int)2, null).toFile().delete();
                    $this$releaseLock_u24lambda_u249.logger.info(DesktopAppLaunch::releaseLock$lambda$9$lambda$7);
                } else {
                    $this$releaseLock_u24lambda_u249.logger.info(DesktopAppLaunch::releaseLock$lambda$9$lambda$8);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block6;
            Object e = object = throwable;
            boolean bl = false;
            this.logger.error((Throwable)e, DesktopAppLaunch::releaseLock$lambda$11$lambda$10);
        }
    }

    @Override
    public void resetFirstLaunchFlag() {
        this.resetLock = true;
    }

    @Nullable
    public Object launch(@NotNull Continuation<? super DesktopAppLaunchState> $completion) {
        DesktopAppLaunchState desktopAppLaunchState;
        AppLockState appLockState = this.acquireLock();
        long pid = ProcessHandle.current().pid();
        boolean acquiredLock = appLockState.getAcquiredLock();
        boolean firstLaunch = appLockState.getFirstLaunch();
        if (this.platform.isMacos()) {
            boolean accessibilityPermissions = MacAppUtils.INSTANCE.checkAccessibilityPermissions();
            desktopAppLaunchState = new DesktopAppLaunchState(pid, acquiredLock, firstLaunch, accessibilityPermissions, null);
        } else if (this.platform.isWindows()) {
            java.nio.file.Path path = this.appPathProvider.getPasteAppPath().toNioPath();
            String installFrom = User32.Companion.isInstalledFromMicrosoftStore(path) ? "Microsoft Store" : null;
            desktopAppLaunchState = new DesktopAppLaunchState(pid, acquiredLock, firstLaunch, true, installFrom);
        } else {
            desktopAppLaunchState = new DesktopAppLaunchState(pid, acquiredLock, firstLaunch, true, null);
        }
        DesktopAppLaunchState appLaunchState = desktopAppLaunchState;
        this._appLaunchState.setValue((Object)appLaunchState);
        return appLaunchState;
    }

    public final void setFirstLaunchCompleted(boolean firstLaunchCompleted) {
        this._firstLaunchCompleted.setValue((Object)firstLaunchCompleted);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object acquireLock$lambda$3$lambda$1() {
        return "Another instance of the application is already running.";
    }

    private static final Object acquireLock$lambda$3$lambda$2() {
        return "Application lock acquired.";
    }

    private static final Object acquireLock$lambda$6$lambda$4() {
        return "Another instance of the application is already running.";
    }

    private static final Object acquireLock$lambda$6$lambda$5() {
        return "Failed to create and lock file";
    }

    private static final Object releaseLock$lambda$9$lambda$7() {
        return "Application lock released and reset.";
    }

    private static final Object releaseLock$lambda$9$lambda$8() {
        return "Application lock released.";
    }

    private static final Object releaseLock$lambda$11$lambda$10() {
        return "Failed to release lock";
    }
}

