/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.streamprovider;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.iface.IHasInputStreamAndReader;
import com.helger.base.io.iface.IHasReader;
import com.helger.base.io.nonblocking.NonBlockingStringReader;
import com.helger.base.io.stream.StringInputStream;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;

public class StringInputStreamProvider
implements IHasInputStreamAndReader,
IHasReader {
    private String m_sData;
    private Charset m_aCharset;

    public StringInputStreamProvider(@Nonnull char[] cArray, @Nonnull Charset charset) {
        this(new String(cArray), charset);
    }

    public StringInputStreamProvider(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        this(new String(cArray, n, n2), charset);
    }

    public StringInputStreamProvider(@Nonnull CharSequence charSequence, @Nonnull Charset charset) {
        this(charSequence.toString(), charset);
    }

    public StringInputStreamProvider(@Nonnull String string, @Nonnull Charset charset) {
        this.m_sData = ValueEnforcer.notNull(string, "Data");
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    @Nonnull
    public final String getData() {
        return this.m_sData;
    }

    @Nonnull
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    @Nonnull
    public final StringInputStream getInputStream() {
        return new StringInputStream(this.m_sData, this.m_aCharset);
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader(@Nonnull Charset charset) {
        return new NonBlockingStringReader(this.m_sData);
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader() {
        return new NonBlockingStringReader(this.m_sData);
    }

    @Override
    public final boolean isReadMultiple() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StringInputStreamProvider stringInputStreamProvider = (StringInputStreamProvider)object;
        return this.m_sData.equals(stringInputStreamProvider.m_sData) && this.m_aCharset.equals(stringInputStreamProvider.m_aCharset);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sData).append(this.m_aCharset).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("data", this.m_sData).append("charset", this.m_aCharset).getToString();
    }
}

