/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.operations;

import dev.whyoleg.cryptography.operations.VerifyFunction;
import dev.whyoleg.cryptography.providers.base.BytesKt;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B/\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/operations/JdkVerifyFunction;", "Ldev/whyoleg/cryptography/operations/VerifyFunction;", "key", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "parameters", "Ljava/security/spec/AlgorithmParameterSpec;", "jsignature", "Ldev/whyoleg/cryptography/providers/jdk/Pooled$Resource;", "Ljava/security/Signature;", "Ldev/whyoleg/cryptography/providers/jdk/JSignature;", "<init>", "(Ljava/security/PublicKey;Ljava/security/spec/AlgorithmParameterSpec;Ldev/whyoleg/cryptography/providers/jdk/Pooled$Resource;)V", "update", "", "source", "", "startIndex", "", "endIndex", "tryVerify", "", "signature", "reset", "verify", "close", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkSignatureVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkSignatureVerifier.kt\ndev/whyoleg/cryptography/providers/jdk/operations/JdkVerifyFunction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
final class JdkVerifyFunction
implements VerifyFunction {
    @NotNull
    private final PublicKey key;
    @Nullable
    private final AlgorithmParameterSpec parameters;
    @NotNull
    private final Pooled.Resource<Signature> jsignature;

    public JdkVerifyFunction(@NotNull PublicKey key, @Nullable AlgorithmParameterSpec parameters, @NotNull Pooled.Resource<Signature> jsignature) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(jsignature, (String)"jsignature");
        this.key = key;
        this.parameters = parameters;
        this.jsignature = jsignature;
        this.reset();
    }

    public void update(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BytesKt.checkBounds((int)source.length, (int)startIndex, (int)endIndex);
        Signature jsignature = this.jsignature.access();
        jsignature.update(source, startIndex, endIndex - startIndex);
    }

    public boolean tryVerify(@NotNull byte[] signature, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        BytesKt.checkBounds((int)signature.length, (int)startIndex, (int)endIndex);
        Signature jsignature = this.jsignature.access();
        return jsignature.verify(signature, startIndex, endIndex - startIndex);
    }

    public void reset() {
        block0: {
            Signature jsignature = this.jsignature.access();
            jsignature.initVerify(this.key);
            AlgorithmParameterSpec algorithmParameterSpec = this.parameters;
            if (algorithmParameterSpec == null) break block0;
            AlgorithmParameterSpec p0 = algorithmParameterSpec;
            boolean bl = false;
            jsignature.setParameter(p0);
        }
    }

    public void verify(@NotNull byte[] signature, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        if (!this.tryVerify(signature, startIndex, endIndex)) {
            boolean bl = false;
            String string = "Invalid signature";
            throw new IllegalStateException(string.toString());
        }
    }

    public void close() {
        this.jsignature.close();
    }
}

