/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.operations;

import dev.whyoleg.cryptography.operations.SignFunction;
import dev.whyoleg.cryptography.providers.base.BytesKt;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/operations/JdkSignFunction;", "Ldev/whyoleg/cryptography/operations/SignFunction;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "parameters", "Ljava/security/spec/AlgorithmParameterSpec;", "jsignature", "Ldev/whyoleg/cryptography/providers/jdk/Pooled$Resource;", "Ljava/security/Signature;", "Ldev/whyoleg/cryptography/providers/jdk/JSignature;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PrivateKey;Ljava/security/spec/AlgorithmParameterSpec;Ldev/whyoleg/cryptography/providers/jdk/Pooled$Resource;)V", "update", "", "source", "", "startIndex", "", "endIndex", "signIntoByteArray", "destination", "destinationOffset", "signToByteArray", "reset", "close", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkSignatureGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkSignatureGenerator.kt\ndev/whyoleg/cryptography/providers/jdk/operations/JdkSignFunction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
final class JdkSignFunction
implements SignFunction {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PrivateKey key;
    @Nullable
    private final AlgorithmParameterSpec parameters;
    @NotNull
    private final Pooled.Resource<Signature> jsignature;

    public JdkSignFunction(@NotNull JdkCryptographyState state, @NotNull PrivateKey key, @Nullable AlgorithmParameterSpec parameters, @NotNull Pooled.Resource<Signature> jsignature) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(jsignature, (String)"jsignature");
        this.state = state;
        this.key = key;
        this.parameters = parameters;
        this.jsignature = jsignature;
        this.reset();
    }

    public void update(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BytesKt.checkBounds((int)source.length, (int)startIndex, (int)endIndex);
        Signature jsignature = this.jsignature.access();
        jsignature.update(source, startIndex, endIndex - startIndex);
    }

    public int signIntoByteArray(@NotNull byte[] destination, int destinationOffset) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        byte[] signature = this.signToByteArray();
        BytesKt.checkBounds((int)destination.length, (int)destinationOffset, (int)(destinationOffset + signature.length));
        ArraysKt.copyInto$default((byte[])signature, (byte[])destination, (int)destinationOffset, (int)destinationOffset, (int)0, (int)8, null);
        return signature.length;
    }

    @NotNull
    public byte[] signToByteArray() {
        Signature jsignature = this.jsignature.access();
        byte[] byArray = jsignature.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sign(...)");
        return byArray;
    }

    public void reset() {
        block0: {
            Signature jsignature = this.jsignature.access();
            jsignature.initSign(this.key, this.state.getSecureRandom());
            AlgorithmParameterSpec algorithmParameterSpec = this.parameters;
            if (algorithmParameterSpec == null) break block0;
            AlgorithmParameterSpec p0 = algorithmParameterSpec;
            boolean bl = false;
            jsignature.setParameter(p0);
        }
    }

    public void close() {
        this.jsignature.close();
    }
}

