/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.operations;

import dev.whyoleg.cryptography.operations.SignFunction;
import dev.whyoleg.cryptography.operations.VerifyFunction;
import dev.whyoleg.cryptography.providers.base.BytesKt;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import java.util.Arrays;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/operations/JdkMacFunction;", "Ldev/whyoleg/cryptography/operations/SignFunction;", "Ldev/whyoleg/cryptography/operations/VerifyFunction;", "mac", "Ldev/whyoleg/cryptography/providers/jdk/Pooled$Resource;", "Ljavax/crypto/Mac;", "Ldev/whyoleg/cryptography/providers/jdk/JMac;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/Pooled$Resource;)V", "update", "", "source", "", "startIndex", "", "endIndex", "signIntoByteArray", "destination", "destinationOffset", "signToByteArray", "tryVerify", "", "signature", "verify", "reset", "close", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkMacSignature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkMacSignature.kt\ndev/whyoleg/cryptography/providers/jdk/operations/JdkMacFunction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
final class JdkMacFunction
implements SignFunction,
VerifyFunction {
    @NotNull
    private final Pooled.Resource<Mac> mac;

    public JdkMacFunction(@NotNull Pooled.Resource<Mac> mac) {
        Intrinsics.checkNotNullParameter(mac, (String)"mac");
        this.mac = mac;
    }

    public void update(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BytesKt.checkBounds((int)source.length, (int)startIndex, (int)endIndex);
        Mac mac = this.mac.access();
        mac.update(source, startIndex, endIndex - startIndex);
    }

    public int signIntoByteArray(@NotNull byte[] destination, int destinationOffset) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Mac mac = this.mac.access();
        BytesKt.checkBounds((int)destination.length, (int)destinationOffset, (int)(destinationOffset + mac.getMacLength()));
        mac.doFinal(destination, destinationOffset);
        return mac.getMacLength();
    }

    @NotNull
    public byte[] signToByteArray() {
        Mac mac = this.mac.access();
        byte[] byArray = mac.doFinal();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    public boolean tryVerify(@NotNull byte[] signature, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        BytesKt.checkBounds((int)signature.length, (int)startIndex, (int)endIndex);
        return Arrays.equals(this.signToByteArray(), ArraysKt.copyOfRange((byte[])signature, (int)startIndex, (int)endIndex));
    }

    public void verify(@NotNull byte[] signature, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        if (!this.tryVerify(signature, startIndex, endIndex)) {
            boolean bl = false;
            String string = "Invalid signature";
            throw new IllegalStateException(string.toString());
        }
    }

    public void reset() {
        this.mac.access().reset();
    }

    public void close() {
        this.mac.close();
    }
}

