/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.materials;

import dev.whyoleg.cryptography.materials.key.Key;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0004\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0004\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00028\u0001*\u00060\u001dj\u0002`\u001eH$\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Ldev/whyoleg/cryptography/providers/jdk/materials/JdkPrivateKeyDecoder;", "KF", "Ldev/whyoleg/cryptography/materials/key/KeyFormat;", "K", "Ldev/whyoleg/cryptography/materials/key/Key;", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "algorithm", "", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/lang/String;)V", "getState", "()Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "keyFactory", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljava/security/KeyFactory;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyFactory;", "getKeyFactory", "()Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "decode", "spec", "Ljava/security/spec/KeySpec;", "(Ljava/security/spec/KeySpec;)Ldev/whyoleg/cryptography/materials/key/Key;", "decodeFromDer", "input", "", "([B)Ldev/whyoleg/cryptography/materials/key/Key;", "convert", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "(Ljava/security/PrivateKey;)Ldev/whyoleg/cryptography/materials/key/Key;", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkPrivateKeyDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkPrivateKeyDecoder.kt\ndev/whyoleg/cryptography/providers/jdk/materials/JdkPrivateKeyDecoder\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n*L\n1#1,23:1\n41#2,5:24\n*S KotlinDebug\n*F\n+ 1 JdkPrivateKeyDecoder.kt\ndev/whyoleg/cryptography/providers/jdk/materials/JdkPrivateKeyDecoder\n*L\n17#1:24,5\n*E\n"})
public abstract class JdkPrivateKeyDecoder<KF extends KeyFormat, K extends Key>
implements KeyDecoder<KF, K> {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final Pooled<KeyFactory> keyFactory;

    public JdkPrivateKeyDecoder(@NotNull JdkCryptographyState state, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.state = state;
        this.keyFactory = this.state.keyFactory(algorithm);
    }

    @NotNull
    protected final JdkCryptographyState getState() {
        return this.state;
    }

    @NotNull
    protected final Pooled<KeyFactory> getKeyFactory() {
        return this.keyFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected final K decode(@NotNull KeySpec spec) {
        PrivateKey privateKey;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Pooled<KeyFactory> pooled = this.keyFactory;
        JdkPrivateKeyDecoder jdkPrivateKeyDecoder = this;
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$borrow((Pooled)this_$iv);
        try {
            KeyFactory it = (KeyFactory)instance$iv;
            boolean bl = false;
            privateKey = it.generatePrivate(spec);
        }
        finally {
            Pooled.access$recycle((Pooled)this_$iv, instance$iv);
        }
        PrivateKey privateKey2 = privateKey;
        Intrinsics.checkNotNullExpressionValue((Object)privateKey2, (String)"use(...)");
        return jdkPrivateKeyDecoder.convert(privateKey2);
    }

    @NotNull
    protected final K decodeFromDer(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.decode(new PKCS8EncodedKeySpec(input));
    }

    @NotNull
    protected abstract K convert(@NotNull PrivateKey var1);
}

