/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.RSA;
import dev.whyoleg.cryptography.operations.Encryptor;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaPublicEncodableKey;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaRawEncryptor;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaRawPublicKey;", "Ldev/whyoleg/cryptography/algorithms/RSA$RAW$PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPublicEncodableKey;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PublicKey;)V", "encryptor", "Ldev/whyoleg/cryptography/operations/Encryptor;", "cryptography-provider-jdk"})
final class RsaRawPublicKey
extends RsaPublicEncodableKey
implements RSA.RAW.PublicKey {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PublicKey key;

    public RsaRawPublicKey(@NotNull JdkCryptographyState state, @NotNull PublicKey key) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super(key);
        this.state = state;
        this.key = key;
    }

    @NotNull
    public Encryptor encryptor() {
        return (Encryptor)new RsaRawEncryptor(this.state, this.key);
    }
}

