/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.RSA;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaRawKeyPair;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkKeyPairGenerator;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.RSAKeyGenParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n*\u00060\u000bj\u0002`\fH\u0014J\u0010\u0010\r\u001a\u00020\u0002*\u00060\u000ej\u0002`\u000fH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaRawKeyPairGenerator;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkKeyPairGenerator;", "Ldev/whyoleg/cryptography/algorithms/RSA$RAW$KeyPair;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "keyGenParameters", "Ljava/security/spec/RSAKeyGenParameterSpec;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/spec/RSAKeyGenParameterSpec;)V", "init", "", "Ljava/security/KeyPairGenerator;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPairGenerator;", "convert", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "cryptography-provider-jdk"})
final class RsaRawKeyPairGenerator
extends JdkKeyPairGenerator<RSA.RAW.KeyPair> {
    @NotNull
    private final RSAKeyGenParameterSpec keyGenParameters;

    public RsaRawKeyPairGenerator(@NotNull JdkCryptographyState state, @NotNull RSAKeyGenParameterSpec keyGenParameters) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)keyGenParameters, (String)"keyGenParameters");
        super(state, "RSA");
        this.keyGenParameters = keyGenParameters;
    }

    @Override
    protected void init(@NotNull KeyPairGenerator $this$init) {
        Intrinsics.checkNotNullParameter((Object)$this$init, (String)"<this>");
        $this$init.initialize(this.keyGenParameters, this.getState().getSecureRandom());
    }

    @Override
    @NotNull
    protected RSA.RAW.KeyPair convert(@NotNull KeyPair $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        return new RsaRawKeyPair(this.getState(), $this$convert);
    }
}

