/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.RSA;
import dev.whyoleg.cryptography.operations.Decryptor;
import dev.whyoleg.cryptography.operations.SignatureGenerator;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaPkcs1Decryptor;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaPrivateEncodableKey;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkSignatureGenerator;
import java.security.PrivateKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPkcs1PrivateKey;", "Ldev/whyoleg/cryptography/algorithms/RSA$PKCS1$PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPrivateEncodableKey;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "hashAlgorithmName", "", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PrivateKey;Ljava/lang/String;)V", "signatureGenerator", "Ldev/whyoleg/cryptography/operations/SignatureGenerator;", "decryptor", "Ldev/whyoleg/cryptography/operations/Decryptor;", "cryptography-provider-jdk"})
final class RsaPkcs1PrivateKey
extends RsaPrivateEncodableKey
implements RSA.PKCS1.PrivateKey {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PrivateKey key;
    @NotNull
    private final String hashAlgorithmName;

    public RsaPkcs1PrivateKey(@NotNull JdkCryptographyState state, @NotNull PrivateKey key, @NotNull String hashAlgorithmName) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)hashAlgorithmName, (String)"hashAlgorithmName");
        super(key);
        this.state = state;
        this.key = key;
        this.hashAlgorithmName = hashAlgorithmName;
    }

    @NotNull
    public SignatureGenerator signatureGenerator() {
        return new JdkSignatureGenerator(this.state, this.key, this.hashAlgorithmName + "withRSA", null);
    }

    @NotNull
    public Decryptor decryptor() {
        return (Decryptor)new RsaPkcs1Decryptor(this.state, this.key);
    }
}

