/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.providers.base.operations.BaseDecryptor;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkCipherFunction;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPkcs1Decryptor;", "Ldev/whyoleg/cryptography/providers/base/operations/BaseDecryptor;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PrivateKey;)V", "cipher", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljavax/crypto/Cipher;", "Ldev/whyoleg/cryptography/providers/jdk/JCipher;", "createDecryptFunction", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkRsaPkcs1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkRsaPkcs1.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/RsaPkcs1Decryptor\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n38#2:128\n1#3:129\n*S KotlinDebug\n*F\n+ 1 JdkRsaPkcs1.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/RsaPkcs1Decryptor\n*L\n122#1:128\n122#1:129\n*E\n"})
final class RsaPkcs1Decryptor
implements BaseDecryptor {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PrivateKey key;
    @NotNull
    private final Pooled<Cipher> cipher;

    public RsaPkcs1Decryptor(@NotNull JdkCryptographyState state, @NotNull PrivateKey key) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.state = state;
        this.key = key;
        this.cipher = this.state.cipher("RSA/ECB/PKCS1Padding");
    }

    @NotNull
    public CipherFunction createDecryptFunction() {
        Pooled.Resource<Cipher> resource;
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$borrowResource = false;
        Pooled.Resource<Cipher> $this$borrowResource_u24lambda_u240$iv = resource = this_$iv.borrowResource();
        boolean bl = false;
        Cipher $this$createDecryptFunction_u24lambda_u240 = $this$borrowResource_u24lambda_u240$iv.access();
        boolean bl2 = false;
        $this$createDecryptFunction_u24lambda_u240.init(2, (Key)this.key, this.state.getSecureRandom());
        Pooled.Resource<Cipher> resource2 = resource;
        return (CipherFunction)new JdkCipherFunction(resource2);
    }
}

