/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.providers.base.operations.BaseAuthenticatedEncryptor;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkCipherFunction;
import java.security.Key;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaOaepEncryptor;", "Ldev/whyoleg/cryptography/providers/base/operations/BaseAuthenticatedEncryptor;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "hashAlgorithmName", "", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PublicKey;Ljava/lang/String;)V", "cipher", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljavax/crypto/Cipher;", "Ldev/whyoleg/cryptography/providers/jdk/JCipher;", "createEncryptFunction", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "associatedData", "", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkRsaOaep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkRsaOaep.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/RsaOaepEncryptor\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n38#2:138\n1#3:139\n1#3:140\n*S KotlinDebug\n*F\n+ 1 JdkRsaOaep.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/RsaOaepEncryptor\n*L\n106#1:138\n106#1:139\n*E\n"})
final class RsaOaepEncryptor
implements BaseAuthenticatedEncryptor {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PublicKey key;
    @NotNull
    private final String hashAlgorithmName;
    @NotNull
    private final Pooled<Cipher> cipher;

    public RsaOaepEncryptor(@NotNull JdkCryptographyState state, @NotNull PublicKey key, @NotNull String hashAlgorithmName) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)hashAlgorithmName, (String)"hashAlgorithmName");
        this.state = state;
        this.key = key;
        this.hashAlgorithmName = hashAlgorithmName;
        this.cipher = this.state.cipher("RSA/ECB/OAEPPadding");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CipherFunction createEncryptFunction(@Nullable byte[] associatedData) {
        PSource.PSpecified pSpecified;
        Pooled.Resource<Cipher> resource;
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$borrowResource = false;
        Pooled.Resource<Cipher> $this$borrowResource_u24lambda_u240$iv = resource = this_$iv.borrowResource();
        boolean bl = false;
        Cipher $this$createEncryptFunction_u24lambda_u240 = $this$borrowResource_u24lambda_u240$iv.access();
        boolean bl2 = false;
        String string = this.hashAlgorithmName;
        String string2 = "MGF1";
        AlgorithmParameterSpec algorithmParameterSpec = new MGF1ParameterSpec(this.hashAlgorithmName);
        if (associatedData != null) {
            void p0;
            byte[] byArray = associatedData;
            AlgorithmParameterSpec algorithmParameterSpec2 = algorithmParameterSpec;
            String string3 = string2;
            String string4 = string;
            boolean bl3 = false;
            PSource.PSpecified pSpecified2 = new PSource.PSpecified((byte[])p0);
            string = string4;
            string2 = string3;
            algorithmParameterSpec = algorithmParameterSpec2;
            pSpecified = pSpecified2;
        } else {
            pSpecified = PSource.PSpecified.DEFAULT;
        }
        PSource pSource = pSpecified;
        AlgorithmParameterSpec algorithmParameterSpec3 = algorithmParameterSpec;
        String string5 = string2;
        String string6 = string;
        OAEPParameterSpec parameters = new OAEPParameterSpec(string6, string5, algorithmParameterSpec3, pSource);
        $this$createEncryptFunction_u24lambda_u240.init(1, (Key)this.key, parameters, this.state.getSecureRandom());
        Pooled.Resource<Cipher> resource2 = resource;
        return (CipherFunction)new JdkCipherFunction(resource2);
    }
}

