/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.BinarySize;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.algorithms.Digest;
import dev.whyoleg.cryptography.algorithms.RSA;
import dev.whyoleg.cryptography.bigint.BigInt;
import dev.whyoleg.cryptography.bigint.BigIntKt;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyGenerator;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaRawKeyPairGenerator;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaRawPrivateKeyDecoder;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaRawPublicKeyDecoder;
import java.security.spec.RSAKeyGenParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J3\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkRsaRaw;", "Ldev/whyoleg/cryptography/algorithms/RSA$RAW;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;)V", "publicKeyDecoder", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/RSA$PublicKey$Format;", "Ldev/whyoleg/cryptography/algorithms/RSA$RAW$PublicKey;", "digest", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "Ldev/whyoleg/cryptography/algorithms/Digest;", "privateKeyDecoder", "Ldev/whyoleg/cryptography/algorithms/RSA$PrivateKey$Format;", "Ldev/whyoleg/cryptography/algorithms/RSA$RAW$PrivateKey;", "keyPairGenerator", "Ldev/whyoleg/cryptography/materials/key/KeyGenerator;", "Ldev/whyoleg/cryptography/algorithms/RSA$RAW$KeyPair;", "keySize", "Ldev/whyoleg/cryptography/BinarySize;", "publicExponent", "Ldev/whyoleg/cryptography/bigint/BigInt;", "keyPairGenerator-imL9hLU", "(ILdev/whyoleg/cryptography/CryptographyAlgorithmId;Ldev/whyoleg/cryptography/bigint/BigInt;)Ldev/whyoleg/cryptography/materials/key/KeyGenerator;", "cryptography-provider-jdk"})
public final class JdkRsaRaw
implements RSA.RAW {
    @NotNull
    private final JdkCryptographyState state;

    public JdkRsaRaw(@NotNull JdkCryptographyState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    @NotNull
    public KeyDecoder<RSA.PublicKey.Format, RSA.RAW.PublicKey> publicKeyDecoder(@NotNull CryptographyAlgorithmId<Digest> digest) {
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        return new RsaRawPublicKeyDecoder(this.state);
    }

    @NotNull
    public KeyDecoder<RSA.PrivateKey.Format, RSA.RAW.PrivateKey> privateKeyDecoder(@NotNull CryptographyAlgorithmId<Digest> digest) {
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        return new RsaRawPrivateKeyDecoder(this.state);
    }

    @NotNull
    public KeyGenerator<RSA.RAW.KeyPair> keyPairGenerator-imL9hLU(int keySize, @NotNull CryptographyAlgorithmId<Digest> digest, @NotNull BigInt publicExponent) {
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)publicExponent, (String)"publicExponent");
        RSAKeyGenParameterSpec rsaParameters = new RSAKeyGenParameterSpec(BinarySize.getInBits-impl((int)keySize), BigIntKt.toJavaBigInteger((BigInt)publicExponent));
        return new RsaRawKeyPairGenerator(this.state, rsaParameters);
    }
}

