/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.algorithms.Digest;
import dev.whyoleg.cryptography.algorithms.HMAC;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyGenerator;
import dev.whyoleg.cryptography.operations.SignatureGenerator;
import dev.whyoleg.cryptography.operations.SignatureVerifier;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyStateKt;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkHmac;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkHmacKt;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkSecretKeyDecoder;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkSecretKeyGenerator;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkMacSignature;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkHmac;", "Ldev/whyoleg/cryptography/algorithms/HMAC;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;)V", "keyWrapper", "Lkotlin/Function1;", "Ljavax/crypto/SecretKey;", "Ldev/whyoleg/cryptography/providers/jdk/JSecretKey;", "Ldev/whyoleg/cryptography/algorithms/HMAC$Key;", "keyDecoder", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/HMAC$Key$Format;", "digest", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "Ldev/whyoleg/cryptography/algorithms/Digest;", "keyGenerator", "Ldev/whyoleg/cryptography/materials/key/KeyGenerator;", "cryptography-provider-jdk"})
public final class JdkHmac
implements HMAC {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final Function1<SecretKey, HMAC.Key> keyWrapper;

    public JdkHmac(@NotNull JdkCryptographyState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.keyWrapper = arg_0 -> JdkHmac.keyWrapper$lambda$0(this, arg_0);
    }

    @NotNull
    public KeyDecoder<HMAC.Key.Format, HMAC.Key> keyDecoder(@NotNull CryptographyAlgorithmId<Digest> digest) {
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        return new JdkSecretKeyDecoder("Hmac" + JdkCryptographyStateKt.hashAlgorithmName(digest), this.keyWrapper);
    }

    @NotNull
    public KeyGenerator<HMAC.Key> keyGenerator(@NotNull CryptographyAlgorithmId<Digest> digest) {
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        int blockSize = JdkHmacKt.access$blockSize(digest);
        return new JdkSecretKeyGenerator<HMAC.Key>(this.state, "Hmac" + JdkCryptographyStateKt.hashAlgorithmName(digest), this.keyWrapper, (Function1<? super javax.crypto.KeyGenerator, Unit>)((Function1)arg_0 -> JdkHmac.keyGenerator$lambda$1(blockSize, this, arg_0)));
    }

    private static final keyWrapper.1.1 keyWrapper$lambda$0(JdkHmac this$0, SecretKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new HMAC.Key(this$0, key){
            private final JdkMacSignature signature;
            {
                JdkCryptographyState jdkCryptographyState = JdkHmac.access$getState$p($receiver);
                String string = $key.getAlgorithm();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAlgorithm(...)");
                this.signature = new JdkMacSignature(jdkCryptographyState, $key, string);
            }

            public SignatureGenerator signatureGenerator() {
                return this.signature;
            }

            public SignatureVerifier signatureVerifier() {
                return this.signature;
            }

            public byte[] encodeToByteArrayBlocking(HMAC.Key.Format format) {
                Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                switch (keyWrapper.1.WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                    case 1: {
                        throw new IllegalStateException((format + " is not supported").toString());
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return this.encodeToRaw();
            }
        };
    }

    private static final Unit keyGenerator$lambda$1(int $blockSize, JdkHmac this$0, javax.crypto.KeyGenerator $this$JdkSecretKeyGenerator) {
        Intrinsics.checkNotNullParameter((Object)$this$JdkSecretKeyGenerator, (String)"$this$JdkSecretKeyGenerator");
        $this$JdkSecretKeyGenerator.init($blockSize, this$0.state.getSecureRandom());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ JdkCryptographyState access$getState$p(JdkHmac $this) {
        return $this.state;
    }
}

