/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.algorithms.Digest;
import dev.whyoleg.cryptography.providers.base.algorithms.BaseHkdf;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkHkdf;", "Ldev/whyoleg/cryptography/providers/base/algorithms/BaseHkdf;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "provider", "Ldev/whyoleg/cryptography/CryptographyProvider;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ldev/whyoleg/cryptography/CryptographyProvider;)V", "digestSize", "", "digest", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "Ldev/whyoleg/cryptography/algorithms/Digest;", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkHkdf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkHkdf.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkHkdf\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n*L\n1#1,20:1\n41#2,5:21\n*S KotlinDebug\n*F\n+ 1 JdkHkdf.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkHkdf\n*L\n17#1:21,5\n*E\n"})
public final class JdkHkdf
extends BaseHkdf {
    @NotNull
    private final JdkCryptographyState state;

    public JdkHkdf(@NotNull JdkCryptographyState state, @NotNull CryptographyProvider provider) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super(provider);
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int digestSize(@NotNull CryptographyAlgorithmId<Digest> digest) {
        int n;
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        Pooled<MessageDigest> this_$iv = this.state.messageDigest(digest.getName());
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$borrow(this_$iv);
        try {
            MessageDigest it = (MessageDigest)instance$iv;
            boolean bl = false;
            n = it.getDigestLength();
        }
        finally {
            Pooled.access$recycle(this_$iv, instance$iv);
        }
        return n;
    }
}

