/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.operations.HashFunction;
import dev.whyoleg.cryptography.providers.base.BytesKt;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkHashFunction;", "Ldev/whyoleg/cryptography/operations/HashFunction;", "messageDigest", "Ldev/whyoleg/cryptography/providers/jdk/Pooled$Resource;", "Ljava/security/MessageDigest;", "Ldev/whyoleg/cryptography/providers/jdk/JMessageDigest;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/Pooled$Resource;)V", "update", "", "source", "", "startIndex", "", "endIndex", "hashIntoByteArray", "destination", "destinationOffset", "hashToByteArray", "reset", "close", "cryptography-provider-jdk"})
final class JdkHashFunction
implements HashFunction {
    @NotNull
    private final Pooled.Resource<MessageDigest> messageDigest;

    public JdkHashFunction(@NotNull Pooled.Resource<MessageDigest> messageDigest) {
        Intrinsics.checkNotNullParameter(messageDigest, (String)"messageDigest");
        this.messageDigest = messageDigest;
    }

    public void update(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BytesKt.checkBounds((int)source.length, (int)startIndex, (int)endIndex);
        MessageDigest messageDigest = this.messageDigest.access();
        messageDigest.update(source, startIndex, endIndex - startIndex);
    }

    public int hashIntoByteArray(@NotNull byte[] destination, int destinationOffset) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        MessageDigest messageDigest = this.messageDigest.access();
        BytesKt.checkBounds((int)destination.length, (int)destinationOffset, (int)(destinationOffset + messageDigest.getDigestLength()));
        return messageDigest.digest(destination, destinationOffset, messageDigest.getDigestLength());
    }

    @NotNull
    public byte[] hashToByteArray() {
        MessageDigest messageDigest = this.messageDigest.access();
        byte[] byArray = messageDigest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    public void reset() {
        MessageDigest messageDigest = this.messageDigest.access();
        messageDigest.reset();
    }

    public void close() {
        this.messageDigest.close();
    }
}

