/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.ECDH;
import dev.whyoleg.cryptography.operations.SharedSecretGenerator;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkEc;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkKeyAgreementKt;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.KeyAgreement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005:\u0003\u0011\u0012\u0013B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002*\u00060\u000bj\u0002`\fH\u0014J\u0010\u0010\n\u001a\u00020\u0003*\u00060\rj\u0002`\u000eH\u0014J\u0010\u0010\n\u001a\u00020\u0004*\u00060\u000fj\u0002`\u0010H\u0014\u00a8\u0006\u0014"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdh;", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc;", "Ldev/whyoleg/cryptography/algorithms/ECDH$PublicKey;", "Ldev/whyoleg/cryptography/algorithms/ECDH$PrivateKey;", "Ldev/whyoleg/cryptography/algorithms/ECDH$KeyPair;", "Ldev/whyoleg/cryptography/algorithms/ECDH;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;)V", "convert", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "EcdhKeyPair", "EcdhPublicKey", "EcdhPrivateKey", "cryptography-provider-jdk"})
public final class JdkEcdh
extends JdkEc<ECDH.PublicKey, ECDH.PrivateKey, ECDH.KeyPair>
implements ECDH {
    public JdkEcdh(@NotNull JdkCryptographyState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(state, null);
    }

    @Override
    @NotNull
    protected ECDH.PublicKey convert(@NotNull PublicKey $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        return new EcdhPublicKey(this.getState(), $this$convert);
    }

    @Override
    @NotNull
    protected ECDH.PrivateKey convert(@NotNull PrivateKey $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        return new EcdhPrivateKey(this.getState(), $this$convert);
    }

    @Override
    @NotNull
    protected ECDH.KeyPair convert(@NotNull KeyPair $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        PublicKey publicKey = $this$convert.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        ECDH.PublicKey publicKey2 = this.convert(publicKey);
        PrivateKey privateKey = $this$convert.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        return new EcdhKeyPair(publicKey2, this.convert(privateKey));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdh$EcdhKeyPair;", "Ldev/whyoleg/cryptography/algorithms/ECDH$KeyPair;", "publicKey", "Ldev/whyoleg/cryptography/algorithms/ECDH$PublicKey;", "privateKey", "Ldev/whyoleg/cryptography/algorithms/ECDH$PrivateKey;", "<init>", "(Ldev/whyoleg/cryptography/algorithms/ECDH$PublicKey;Ldev/whyoleg/cryptography/algorithms/ECDH$PrivateKey;)V", "getPublicKey", "()Ldev/whyoleg/cryptography/algorithms/ECDH$PublicKey;", "getPrivateKey", "()Ldev/whyoleg/cryptography/algorithms/ECDH$PrivateKey;", "cryptography-provider-jdk"})
    private static final class EcdhKeyPair
    implements ECDH.KeyPair {
        @NotNull
        private final ECDH.PublicKey publicKey;
        @NotNull
        private final ECDH.PrivateKey privateKey;

        public EcdhKeyPair(@NotNull ECDH.PublicKey publicKey, @NotNull ECDH.PrivateKey privateKey) {
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        @NotNull
        public ECDH.PublicKey getPublicKey() {
            return this.publicKey;
        }

        @NotNull
        public ECDH.PrivateKey getPrivateKey() {
            return this.privateKey;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdh$EcdhPrivateKey;", "Ldev/whyoleg/cryptography/algorithms/ECDH$PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$BaseEcPrivateKey;", "Ldev/whyoleg/cryptography/operations/SharedSecretGenerator;", "Ldev/whyoleg/cryptography/algorithms/ECDH$PublicKey;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PrivateKey;)V", "getKey", "()Ljava/security/PrivateKey;", "keyAgreement", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljavax/crypto/KeyAgreement;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyAgreement;", "sharedSecretGenerator", "generateSharedSecretToByteArrayBlocking", "", "other", "cryptography-provider-jdk"})
    @SourceDebugExtension(value={"SMAP\nJdkEcdh.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEcdh.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdh$EcdhPrivateKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
    private static final class EcdhPrivateKey
    extends JdkEc.BaseEcPrivateKey
    implements ECDH.PrivateKey,
    SharedSecretGenerator<ECDH.PublicKey> {
        @NotNull
        private final JdkCryptographyState state;
        @NotNull
        private final PrivateKey key;
        @NotNull
        private final Pooled<KeyAgreement> keyAgreement;

        public EcdhPrivateKey(@NotNull JdkCryptographyState state, @NotNull PrivateKey key) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key);
            this.state = state;
            this.key = key;
            this.keyAgreement = this.state.keyAgreement("ECDH");
        }

        @NotNull
        public final PrivateKey getKey() {
            return this.key;
        }

        @NotNull
        public SharedSecretGenerator<ECDH.PublicKey> sharedSecretGenerator() {
            return this;
        }

        @NotNull
        public byte[] generateSharedSecretToByteArrayBlocking(@NotNull ECDH.PublicKey other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!(other instanceof EcdhPublicKey)) {
                boolean bl = false;
                String string = "Only key produced by JDK provider is supported";
                throw new IllegalStateException(string.toString());
            }
            return JdkKeyAgreementKt.doAgreement(this.keyAgreement, this.state, this.key, ((EcdhPublicKey)other).getKey());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdh$EcdhPublicKey;", "Ldev/whyoleg/cryptography/algorithms/ECDH$PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$BaseEcPublicKey;", "Ldev/whyoleg/cryptography/operations/SharedSecretGenerator;", "Ldev/whyoleg/cryptography/algorithms/ECDH$PrivateKey;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PublicKey;)V", "getKey", "()Ljava/security/PublicKey;", "keyAgreement", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljavax/crypto/KeyAgreement;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyAgreement;", "sharedSecretGenerator", "generateSharedSecretToByteArrayBlocking", "", "other", "cryptography-provider-jdk"})
    @SourceDebugExtension(value={"SMAP\nJdkEcdh.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEcdh.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdh$EcdhPublicKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
    private static final class EcdhPublicKey
    extends JdkEc.BaseEcPublicKey
    implements ECDH.PublicKey,
    SharedSecretGenerator<ECDH.PrivateKey> {
        @NotNull
        private final JdkCryptographyState state;
        @NotNull
        private final PublicKey key;
        @NotNull
        private final Pooled<KeyAgreement> keyAgreement;

        public EcdhPublicKey(@NotNull JdkCryptographyState state, @NotNull PublicKey key) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key);
            this.state = state;
            this.key = key;
            this.keyAgreement = this.state.keyAgreement("ECDH");
        }

        @NotNull
        public final PublicKey getKey() {
            return this.key;
        }

        @NotNull
        public SharedSecretGenerator<ECDH.PrivateKey> sharedSecretGenerator() {
            return this;
        }

        @NotNull
        public byte[] generateSharedSecretToByteArrayBlocking(@NotNull ECDH.PrivateKey other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!(other instanceof EcdhPrivateKey)) {
                boolean bl = false;
                String string = "Only key produced by JDK provider is supported";
                throw new IllegalStateException(string.toString());
            }
            return JdkKeyAgreementKt.doAgreement(this.keyAgreement, this.state, ((EcdhPrivateKey)other).getKey(), this.key);
        }
    }
}

