/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b*\u00060\fj\u0002`\rH\u0002\u00a8\u0006\u000e"}, d2={"curveOrderSize", "", "Ljava/security/spec/ECParameterSpec;", "decodePoint", "Ljava/security/spec/ECPoint;", "bytes", "", "modSqrt", "Ljava/math/BigInteger;", "p", "curveName", "", "Ljava/security/AlgorithmParameters;", "Ldev/whyoleg/cryptography/providers/jdk/JAlgorithmParameters;", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkEc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEc.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1#2:240\n*E\n"})
public final class JdkEcKt {
    public static final int curveOrderSize(@NotNull ECParameterSpec $this$curveOrderSize) {
        Intrinsics.checkNotNullParameter((Object)$this$curveOrderSize, (String)"<this>");
        return ($this$curveOrderSize.getCurve().getField().getFieldSize() + 7) / 8;
    }

    @NotNull
    public static final ECPoint decodePoint(@NotNull ECParameterSpec $this$decodePoint, @NotNull byte[] bytes) {
        ECPoint eCPoint;
        Intrinsics.checkNotNullParameter((Object)$this$decodePoint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int fieldSize = JdkEcKt.curveOrderSize($this$decodePoint);
        switch (bytes[0]) {
            case 2: 
            case 3: {
                if (!(bytes.length == fieldSize + 1)) {
                    boolean $i$a$-check-JdkEcKt$decodePoint$32 = false;
                    String $i$a$-check-JdkEcKt$decodePoint$32 = "Wrong compressed key size " + bytes.length;
                    throw new IllegalStateException($i$a$-check-JdkEcKt$decodePoint$32.toString());
                }
                ECField eCField = $this$decodePoint.getCurve().getField();
                Intrinsics.checkNotNull((Object)eCField, (String)"null cannot be cast to non-null type java.security.spec.ECFieldFp");
                BigInteger p = ((ECFieldFp)eCField).getP();
                BigInteger a = $this$decodePoint.getCurve().getA();
                BigInteger b = $this$decodePoint.getCurve().getB();
                BigInteger x = new BigInteger(1, ArraysKt.copyOfRange((byte[])bytes, (int)1, (int)bytes.length));
                BigInteger bigInteger = x.multiply(x).add(a).multiply(x).add(b).mod(p);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"mod(...)");
                Intrinsics.checkNotNull((Object)p);
                BigInteger y = JdkEcKt.modSqrt(bigInteger, p);
                if (y.testBit(0) != (bytes[0] == 3)) {
                    BigInteger bigInteger2 = p.subtract(y);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"subtract(...)");
                    y = bigInteger2;
                }
                eCPoint = new ECPoint(x, y);
                break;
            }
            case 4: {
                if (!(bytes.length == fieldSize * 2 + 1)) {
                    boolean $i$a$-check-JdkEcKt$decodePoint$42 = false;
                    String $i$a$-check-JdkEcKt$decodePoint$42 = "Wrong uncompressed key size " + bytes.length;
                    throw new IllegalStateException($i$a$-check-JdkEcKt$decodePoint$42.toString());
                }
                byte[] x = ArraysKt.copyOfRange((byte[])bytes, (int)1, (int)(fieldSize + 1));
                byte[] y = ArraysKt.copyOfRange((byte[])bytes, (int)(fieldSize + 1), (int)(fieldSize + 1 + fieldSize));
                eCPoint = new ECPoint(new BigInteger(1, x), new BigInteger(1, y));
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported key type " + bytes[0]).toString());
            }
        }
        return eCPoint;
    }

    @NotNull
    public static final BigInteger modSqrt(@NotNull BigInteger $this$modSqrt, @NotNull BigInteger p) {
        Intrinsics.checkNotNullParameter((Object)$this$modSqrt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (!(p.testBit(0) && p.testBit(1))) {
            boolean bl = false;
            String string = "Unsupported curve modulus";
            throw new IllegalStateException(string.toString());
        }
        BigInteger bigInteger = $this$modSqrt.modPow(p.add(BigInteger.ONE).shiftRight(2), p);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"modPow(...)");
        return bigInteger;
    }

    private static final String curveName(AlgorithmParameters $this$curveName) {
        String string = $this$curveName.getParameterSpec(ECGenParameterSpec.class).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public static final /* synthetic */ String access$curveName(AlgorithmParameters $receiver) {
        return JdkEcKt.curveName($receiver);
    }
}

