/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.providers.base.algorithms.BaseAesImplicitIvDecryptFunction;
import dev.whyoleg.cryptography.providers.base.algorithms.BaseAesImplicitIvEncryptFunction;
import dev.whyoleg.cryptography.providers.base.algorithms.BaseAesIvCipher;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkCipherFunction;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u00060\u000fj\u0002`\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkAesIvCipher;", "Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesIvCipher;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljavax/crypto/SecretKey;", "Ldev/whyoleg/cryptography/providers/jdk/JSecretKey;", "ivSize", "", "algorithm", "", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljavax/crypto/SecretKey;ILjava/lang/String;)V", "cipher", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljavax/crypto/Cipher;", "Ldev/whyoleg/cryptography/providers/jdk/JCipher;", "createEncryptFunction", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "createDecryptFunction", "createEncryptFunctionWithIv", "iv", "", "createDecryptFunctionWithIv", "startIndex", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkAesIvCipher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkAesIvCipher.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkAesIvCipher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n*L\n1#1,46:1\n1#2:47\n1#2:49\n1#2:51\n38#3:48\n38#3:50\n*S KotlinDebug\n*F\n+ 1 JdkAesIvCipher.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkAesIvCipher\n*L\n31#1:49\n37#1:51\n31#1:48\n37#1:50\n*E\n"})
public final class JdkAesIvCipher
implements BaseAesIvCipher {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final SecretKey key;
    private final int ivSize;
    @NotNull
    private final Pooled<Cipher> cipher;

    public JdkAesIvCipher(@NotNull JdkCryptographyState state, @NotNull SecretKey key, int ivSize, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.state = state;
        this.key = key;
        this.ivSize = ivSize;
        this.cipher = this.state.cipher(algorithm);
    }

    @NotNull
    public CipherFunction createEncryptFunction() {
        byte[] byArray = new byte[this.ivSize];
        SecureRandom secureRandom = this.state.getSecureRandom();
        byte[] p0 = byArray;
        boolean bl = false;
        secureRandom.nextBytes(p0);
        byte[] iv = byArray;
        return (CipherFunction)new BaseAesImplicitIvEncryptFunction(iv, this.createEncryptFunctionWithIv(iv));
    }

    @NotNull
    public CipherFunction createDecryptFunction() {
        return (CipherFunction)new BaseAesImplicitIvDecryptFunction(this.ivSize, (Function2)new Function2<byte[], Integer, CipherFunction>((Object)this){

            public final CipherFunction invoke(byte[] p0, int p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return JdkAesIvCipher.access$createDecryptFunctionWithIv((JdkAesIvCipher)this.receiver, p0, p1);
            }
        });
    }

    @NotNull
    public CipherFunction createEncryptFunctionWithIv(@NotNull byte[] iv) {
        Pooled.Resource<Cipher> resource;
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$borrowResource = false;
        Pooled.Resource<Cipher> $this$borrowResource_u24lambda_u240$iv = resource = this_$iv.borrowResource();
        boolean bl = false;
        Cipher $this$createEncryptFunctionWithIv_u24lambda_u240 = $this$borrowResource_u24lambda_u240$iv.access();
        boolean bl2 = false;
        $this$createEncryptFunctionWithIv_u24lambda_u240.init(1, (Key)this.key, new IvParameterSpec(iv), this.state.getSecureRandom());
        Pooled.Resource<Cipher> resource2 = resource;
        return (CipherFunction)new JdkCipherFunction(resource2);
    }

    private final CipherFunction createDecryptFunctionWithIv(byte[] iv, int startIndex) {
        Pooled.Resource<Cipher> resource;
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$borrowResource = false;
        Pooled.Resource<Cipher> $this$borrowResource_u24lambda_u240$iv = resource = this_$iv.borrowResource();
        boolean bl = false;
        Cipher $this$createDecryptFunctionWithIv_u24lambda_u241 = $this$borrowResource_u24lambda_u240$iv.access();
        boolean bl2 = false;
        $this$createDecryptFunctionWithIv_u24lambda_u241.init(2, (Key)this.key, new IvParameterSpec(iv, startIndex, this.ivSize), this.state.getSecureRandom());
        Pooled.Resource<Cipher> resource2 = resource;
        return (CipherFunction)new JdkCipherFunction(resource2);
    }

    @NotNull
    public CipherFunction createDecryptFunctionWithIv(@NotNull byte[] iv) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        return this.createDecryptFunctionWithIv(iv, 0);
    }

    public static final /* synthetic */ CipherFunction access$createDecryptFunctionWithIv(JdkAesIvCipher $this, byte[] iv, int startIndex) {
        return $this.createDecryptFunctionWithIv(iv, startIndex);
    }
}

