/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.AES;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkAesIvCipher;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkEncodableKey;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkAesCtrKey;", "Ldev/whyoleg/cryptography/algorithms/AES$CTR$Key;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey;", "Ldev/whyoleg/cryptography/algorithms/AES$Key$Format;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljavax/crypto/SecretKey;", "Ldev/whyoleg/cryptography/providers/jdk/JSecretKey;", "<init>", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljavax/crypto/SecretKey;)V", "cipher", "Ldev/whyoleg/cryptography/algorithms/AES$IvCipher;", "encodeToByteArrayBlocking", "", "format", "cryptography-provider-jdk"})
final class JdkAesCtrKey
extends JdkEncodableKey<AES.Key.Format>
implements AES.CTR.Key {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final SecretKey key;

    public JdkAesCtrKey(@NotNull JdkCryptographyState state, @NotNull SecretKey key) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super(key);
        this.state = state;
        this.key = key;
    }

    @NotNull
    public AES.IvCipher cipher() {
        return (AES.IvCipher)new JdkAesIvCipher(this.state, this.key, 16, "AES/CTR/NoPadding");
    }

    @NotNull
    public byte[] encodeToByteArrayBlocking(@NotNull AES.Key.Format format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                throw new IllegalStateException((format + " is not supported").toString());
            }
            case 2: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.encodeToRaw();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AES.Key.Format.values().length];
            try {
                nArray[AES.Key.Format.JWK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AES.Key.Format.RAW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

