/*
 * Decompiled with CFR 0.152.
 */
package app.cash.sqldelight.driver.jdbc.sqlite;

import app.cash.sqldelight.driver.jdbc.ConnectionManager;
import app.cash.sqldelight.driver.jdbc.sqlite.JdbcSqliteDriverConnectionManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapp/cash/sqldelight/driver/jdbc/sqlite/ThreadedConnectionManager;", "Lapp/cash/sqldelight/driver/jdbc/sqlite/JdbcSqliteDriverConnectionManager;", "url", "", "properties", "Ljava/util/Properties;", "(Ljava/lang/String;Ljava/util/Properties;)V", "connections", "Ljava/lang/ThreadLocal;", "Ljava/sql/Connection;", "value", "Lapp/cash/sqldelight/driver/jdbc/ConnectionManager$Transaction;", "transaction", "getTransaction", "()Lapp/cash/sqldelight/driver/jdbc/ConnectionManager$Transaction;", "setTransaction", "(Lapp/cash/sqldelight/driver/jdbc/ConnectionManager$Transaction;)V", "transactions", "close", "", "closeConnection", "connection", "getConnection", "sqldelight-sqlite-driver"})
@SourceDebugExtension(value={"SMAP\nJdbcSqliteDriver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcSqliteDriver.kt\napp/cash/sqldelight/driver/jdbc/sqlite/ThreadedConnectionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
final class ThreadedConnectionManager
extends JdbcSqliteDriverConnectionManager {
    @NotNull
    private final String url;
    @NotNull
    private final Properties properties;
    @NotNull
    private final ThreadLocal<ConnectionManager.Transaction> transactions;
    @NotNull
    private final ThreadLocal<Connection> connections;

    public ThreadedConnectionManager(@NotNull String url, @NotNull Properties properties) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.url = url;
        this.properties = properties;
        this.transactions = new ThreadLocal();
        this.connections = new ThreadLocal();
    }

    @Nullable
    public ConnectionManager.Transaction getTransaction() {
        return this.transactions.get();
    }

    public void setTransaction(@Nullable ConnectionManager.Transaction value) {
        this.transactions.set(value);
    }

    @NotNull
    public Connection getConnection() {
        ThreadLocal<Connection> threadLocal = this.connections;
        Connection connection = threadLocal.get();
        if (connection == null) {
            Connection connection2;
            boolean bl = false;
            Connection connection3 = DriverManager.getConnection(this.url, this.properties);
            Intrinsics.checkNotNullExpressionValue((Object)connection3, (String)"getConnection(...)");
            Connection connection4 = connection2 = connection3;
            threadLocal.set(connection4);
            connection = connection2;
        }
        return connection;
    }

    public void closeConnection(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (!Intrinsics.areEqual((Object)this.connections.get(), (Object)connection)) {
            boolean bl = false;
            String string = "Connections must be closed on the thread that opened them";
            throw new IllegalStateException(string.toString());
        }
        if (this.getTransaction() == null) {
            connection.close();
            this.connections.remove();
        }
    }

    public void close() {
    }
}

