/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.jna.ClassUtils;
import dorkbox.systemTray.SystemTray;
import javassist.CtBehavior;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.InstructionPrinter;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Mnemonic;

class SystemTrayFixes {
    SystemTrayFixes() {
    }

    protected static boolean isSwingTrayLoaded(String className) {
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            return ClassUtils.isClassLoaded((ClassLoader)cl, (String)className) || ClassUtils.isClassLoaded((ClassLoader)cl, (String)"java.awt.SystemTray");
        }
        catch (Throwable e) {
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Error detecting if the Swing SystemTray is loaded, unexpected error.", e);
            }
            return true;
        }
    }

    protected static void fixTraySize(CtBehavior[] behaviors, int oldTraySize, int newTraySize) {
        for (CtBehavior behavior : behaviors) {
            MethodInfo methodInfo = behavior.getMethodInfo();
            CodeIterator methodIterator = methodInfo.getCodeAttribute().iterator();
            while (methodIterator.hasNext()) {
                try {
                    int i;
                    int index = methodIterator.next();
                    int opcode = methodIterator.byteAt(index);
                    if (opcode != 16 || (i = methodIterator.byteAt(index + 1)) != oldTraySize) continue;
                    methodIterator.writeByte((int)((byte)newTraySize), index + 1);
                }
                catch (BadBytecode badBytecode) {
                    badBytecode.printStackTrace();
                }
            }
        }
    }

    protected static void showMethodBytecode(CtBehavior constructorOrMethod) throws BadBytecode {
        MethodInfo methodInfo = constructorOrMethod.getMethodInfo();
        ConstPool pool2 = methodInfo.getConstPool();
        CodeIterator ci = methodInfo.getCodeAttribute().iterator();
        int lineNumber = -1;
        StringBuilder collector = new StringBuilder();
        int lastLine = -1;
        while (ci.hasNext()) {
            int index = ci.next();
            lineNumber = methodInfo.getLineNumber(index);
            int op = ci.byteAt(index);
            if (lastLine == -1) {
                lastLine = lineNumber;
            }
            if (lineNumber != lastLine) {
                if (collector.length() > 0) {
                    System.err.println(lastLine + " : " + collector);
                }
                lastLine = lineNumber;
                collector.delete(0, collector.length());
            }
            collector.append(Mnemonic.OPCODE[op]).append(" ");
            System.out.println(lineNumber + " * " + Mnemonic.OPCODE[op] + "  ");
            System.out.println(lineNumber + " * " + InstructionPrinter.instructionString((CodeIterator)ci, (int)index, (ConstPool)pool2));
        }
        if (collector.length() > 0) {
            System.err.println(lineNumber + " : " + collector);
        }
    }
}

