/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.systemTray.ui.osx.AwtOsxMenu;
import dorkbox.systemTray.util.AwtAccessor;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.util.SwingUtil;
import java.awt.CheckboxMenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class AwtOsxMenuItemCheckbox
implements CheckboxPeer {
    private final AwtOsxMenu parent;
    private final CheckboxMenuItem _native = new CheckboxMenuItem();
    private volatile ItemListener callback;
    private volatile boolean isChecked = false;
    private final Object peerObj;

    AwtOsxMenuItemCheckbox(AwtOsxMenu parent) {
        this.parent = parent;
        parent._native.add(this._native);
        this.peerObj = AwtAccessor.getPeer(this._native);
    }

    @Override
    public void setEnabled(Checkbox menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(menuItem.getEnabled()));
    }

    @Override
    public void setText(Checkbox menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setLabel(menuItem.getText()));
    }

    @Override
    public void setCallback(final Checkbox menuItem) {
        ActionListener callback;
        if (this.callback != null) {
            this._native.removeItemListener(this.callback);
        }
        if ((callback = menuItem.getCallback()) != null) {
            this.callback = new ItemListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    menuItem.setChecked(!AwtOsxMenuItemCheckbox.this.isChecked);
                    EventDispatch.runLater(() -> {
                        try {
                            this.cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu checkbox entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                        }
                    });
                }
            };
            this._native.addItemListener(this.callback);
        }
    }

    @Override
    public void setShortcut(Checkbox menuItem) {
        int vKey = SwingUtil.INSTANCE.getVirtualKey(menuItem.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setShortcut(new MenuShortcut(vKey)));
    }

    @Override
    public void setTooltip(Checkbox menuItem) {
        String tooltipText = menuItem.getTooltip();
        if (this.peerObj != null && tooltipText != null) {
            SwingUtil.INSTANCE.invokeLater(() -> {
                try {
                    AwtAccessor.setToolTipText(this.peerObj, tooltipText);
                }
                catch (Exception e) {
                    SystemTray.logger.error("Unable to setTooltip for awt-osx menus.", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void setChecked(Checkbox menuItem) {
        boolean checked = menuItem.getChecked();
        if (checked != this.isChecked) {
            this.isChecked = checked;
            SwingUtil.INSTANCE.invokeLater(() -> this._native.setState(this.isChecked));
        }
    }

    @Override
    public void remove() {
        SwingUtil.INSTANCE.invokeLater(() -> {
            this._native.deleteShortcut();
            this._native.setEnabled(false);
            if (this.callback != null) {
                this._native.removeItemListener(this.callback);
                this.callback = null;
            }
            this.parent._native.remove(this._native);
            this._native.removeNotify();
        });
    }
}

