/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.gnomeShell;

import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.gnomeShell.ExtensionSupport;
import java.io.File;
import java.util.List;

public class LegacyExtension
extends ExtensionSupport {
    private static final String UID = "SystemTray@Dorkbox";
    private static final String SHELL_RESTART_COMMAND = "gnome-shell --replace &";

    public static void install(String trayName) {
        boolean success;
        String gnomeVersion;
        if (OS.DesktopEnv.INSTANCE.isWayland()) {
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Gnome-shell legacy extension not possible with wayland.");
            }
            return;
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installing the legacy gnome-shell extension.");
        }
        if ((gnomeVersion = ExtensionSupport.getGnomeVersion()) == null) {
            return;
        }
        List<String> enabledExtensions = LegacyExtension.getEnabledExtensions();
        boolean hasTopIcons = enabledExtensions.contains("topIcons@adel.gadllah@gmail.com");
        boolean hasSystemTray = enabledExtensions.contains(UID);
        if (hasTopIcons) {
            return;
        }
        String userHome = System.getProperty("user.home");
        File directory = new File(userHome + "/.local/share/gnome-shell/extensions/" + UID);
        File metaDatafile = new File(directory, "metadata.json");
        String metadata = ExtensionSupport.createMetadata(UID, SystemTray.getVersion(), trayName, gnomeVersion);
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Checking the legacy gnome-shell extension");
        }
        if (hasSystemTray && !ExtensionSupport.needsUpgrade(metadata, metaDatafile)) {
            return;
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installing legacy gnome-shell extension");
        }
        if ((success = ExtensionSupport.writeFile(metadata, metaDatafile)) && !hasSystemTray) {
            boolean installedJs = ExtensionSupport.installFile("extension.js", directory, trayName);
            if (!installedJs) {
                SystemTray.logger.error("Unable to install legacy gnome-shell extension!!");
            } else if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Enabling legacy gnome-shell extension");
            }
            if (!enabledExtensions.contains(UID)) {
                enabledExtensions.add(UID);
            }
            LegacyExtension.setEnabledExtensions(enabledExtensions);
            LegacyExtension.restartShell(SHELL_RESTART_COMMAND);
        }
    }

    public static void unInstall() {
        if (OS.DesktopEnv.INSTANCE.isWayland()) {
            if (OS.Linux.INSTANCE.isUbuntu() && OS.Linux.INSTANCE.getUbuntuVersion()[0] == 17) {
                return;
            }
            if (OS.Linux.INSTANCE.isFedora()) {
                return;
            }
            if (SystemTray.DEBUG) {
                SystemTray.logger.warn("Trying to restart the shell with an unknown version of wayland. Please create an issue with OS and debug information.");
            } else {
                SystemTray.logger.warn("Trying to restart the shell with an unknown version of wayland. Please set `SystemTray.DEBUG=true;` then create an issue with OS and debug information.");
            }
        }
        LegacyExtension.unInstall(UID, SHELL_RESTART_COMMAND);
    }

    public static void restartShell() {
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("DEBUG mode enabled. You need to log-out/in or manually restart the shell via '{}' to apply the changes.", (Object)SHELL_RESTART_COMMAND);
            return;
        }
        LegacyExtension.restartShell(SHELL_RESTART_COMMAND);
    }
}

