/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mime;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.mime.EMimeQuoting;
import com.helger.mime.parse.MimeTypeParser;
import jakarta.annotation.Nonnull;

@Immutable
public class MimeTypeParameter {
    private final String m_sAttribute;
    private final String m_sValue;
    private final boolean m_bValueRequiresQuoting;

    public MimeTypeParameter(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.isTrue((boolean)MimeTypeParser.isToken(string), () -> "MimeType parameter name is not a valid token: " + string);
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_sAttribute = string;
        this.m_sValue = string2;
        this.m_bValueRequiresQuoting = !MimeTypeParser.isToken(string2);
    }

    @Nonnull
    @Nonempty
    public String getAttribute() {
        return this.m_sAttribute;
    }

    @Nonnull
    public String getValue() {
        return this.m_sValue;
    }

    public boolean isValueRequiringQuoting() {
        return this.m_bValueRequiresQuoting;
    }

    @Nonnull
    @Nonempty
    public String getValueQuotedIfNecessary(@Nonnull EMimeQuoting eMimeQuoting) {
        return this.m_bValueRequiresQuoting ? eMimeQuoting.getQuotedString(this.m_sValue) : this.m_sValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MimeTypeParameter mimeTypeParameter = (MimeTypeParameter)object;
        return this.m_sAttribute.equals(mimeTypeParameter.m_sAttribute) && this.m_sValue.equals(mimeTypeParameter.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sAttribute).append((Object)this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Attribute", (Object)this.m_sAttribute).append("Value", (Object)this.m_sValue).append("ValueRequiresQuoting", this.m_bValueRequiresQuoting).getToString();
    }
}

