/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mime;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.base.string.StringHelper;
import com.helger.mime.MimeType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EMimeContentType implements IHasID<String>
{
    APPLICATION("application"),
    AUDIO("audio"),
    EXAMPLE("example"),
    FONT("font"),
    IMAGE("image"),
    MESSAGE("message"),
    MODEL("model"),
    MULTIPART("multipart"),
    TEXT("text"),
    VIDEO("video"),
    CHEMICAL("chemical"),
    FLV_APPLICATION("flv-application"),
    INODE("inode"),
    WWW("www"),
    X_CONFERENCE("x-conference"),
    X_CONTENT("x-content"),
    X_DIRECTORY("x-directory"),
    X_EPOC("x-epoc"),
    X_WORLD("x-world"),
    ZZ_APPLICATION("zz-application"),
    _STAR("*");

    private final String m_sText;

    private EMimeContentType(String string2) {
        this.m_sText = string2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sText;
    }

    @Nonnull
    @Nonempty
    public String getText() {
        return this.m_sText;
    }

    @Nonnull
    public MimeType buildMimeType(@Nonnull @Nonempty String string) {
        return new MimeType(this, string);
    }

    public boolean isTypeOf(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        int n = string.indexOf(47);
        if (n < 0) {
            return false;
        }
        return this.m_sText.equalsIgnoreCase(string.substring(0, n));
    }

    @Nullable
    public static EMimeContentType getFromIDOrNull(@Nullable String string) {
        return (EMimeContentType)EnumHelper.getFromIDCaseInsensitiveOrNull(EMimeContentType.class, (String)string);
    }
}

