/*
 * Decompiled with CFR 0.152.
 */
package com.helger.typeconvert.util;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsIterableIterator;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.collection.map.LRUMap;
import jakarta.annotation.Nonnull;
import java.lang.ref.WeakReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ClassHierarchyCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassHierarchyCache.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<String, ClassList> CLASS_HIERARCHY = new LRUMap(1000);
    private static final ClassHierarchyCache INSTANCE = new ClassHierarchyCache();

    private ClassHierarchyCache() {
    }

    @Nonnull
    public static EChange clearCache() {
        EChange eChange = (EChange)RW_LOCK.writeLockedGet(() -> CLASS_HIERARCHY.removeAll());
        if (eChange.isUnchanged()) {
            return EChange.UNCHANGED;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache was cleared: " + ClassHierarchyCache.class.getName());
        }
        return EChange.CHANGED;
    }

    @Nonnull
    private static ClassList _getClassList(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        String string = clazz.getName();
        ClassList classList = (ClassList)RW_LOCK.readLockedGet(() -> (ClassList)CLASS_HIERARCHY.get((Object)string));
        if (classList == null) {
            classList = (ClassList)RW_LOCK.writeLockedGet(() -> (ClassList)CLASS_HIERARCHY.computeIfAbsent((Object)string, string -> new ClassList(clazz)));
        }
        return classList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<Class<?>> getClassHierarchy(@Nonnull Class<?> clazz) {
        return ClassHierarchyCache._getClassList(clazz).getAsSet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Class<?>> getClassHierarchyList(@Nonnull Class<?> clazz) {
        return ClassHierarchyCache._getClassList(clazz).getAsList();
    }

    @Nonnull
    public static ICommonsIterable<WeakReference<Class<?>>> getClassHierarchyIterator(@Nonnull Class<?> clazz) {
        return ClassHierarchyCache._getClassList(clazz);
    }

    @Immutable
    private static final class ClassList
    implements ICommonsIterable<WeakReference<Class<?>>> {
        private final ICommonsList<WeakReference<Class<?>>> m_aList = new CommonsArrayList();

        public ClassList(@Nonnull Class<?> clazz) {
            ValueEnforcer.notNull(clazz, (String)"Class");
            CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            commonsArrayList.add(clazz);
            while (!commonsArrayList.isEmpty()) {
                Class clazz2 = (Class)commonsArrayList.removeFirstOrNull();
                commonsLinkedHashSet.add((Object)clazz2);
                for (Class<?> clazz3 : clazz2.getInterfaces()) {
                    commonsArrayList.add(0, clazz3);
                }
                if (clazz2.getSuperclass() == null) continue;
                commonsArrayList.add(0, clazz2.getSuperclass());
            }
            for (Class<?>[] classArray : commonsLinkedHashSet) {
                this.m_aList.add(new WeakReference<Class<?>[]>(classArray));
            }
        }

        @Nonnull
        @ReturnsMutableCopy
        public ICommonsOrderedSet<Class<?>> getAsSet() {
            CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet(this.m_aList.size());
            for (WeakReference weakReference : this.m_aList) {
                Class clazz = (Class)weakReference.get();
                if (clazz == null) continue;
                commonsLinkedHashSet.add((Object)clazz);
            }
            return commonsLinkedHashSet;
        }

        @Nonnull
        @ReturnsMutableCopy
        public ICommonsList<Class<?>> getAsList() {
            CommonsArrayList commonsArrayList = new CommonsArrayList(this.m_aList.size());
            for (WeakReference weakReference : this.m_aList) {
                Class clazz = (Class)weakReference.get();
                if (clazz == null) continue;
                commonsArrayList.add((Object)clazz);
            }
            return commonsArrayList;
        }

        @Nonnull
        public ICommonsIterableIterator<WeakReference<Class<?>>> iterator() {
            return this.m_aList.iterator2();
        }

        public String toString() {
            return new ToStringGenerator((Object)this).append("list", this.m_aList).getToString();
        }
    }
}

