/*
 * Decompiled with CFR 0.152.
 */
package com.helger.typeconvert.trait;

import com.helger.annotation.Nonnegative;
import com.helger.base.reflection.GenericReflection;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.typeconvert.impl.TypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

@FunctionalInterface
public interface IGetterByIndexTrait {
    @Nullable
    public Object getValue(@Nonnegative int var1);

    @Nullable
    default public Class<?> getValueClass(@Nonnegative int n) {
        Object object = this.getValue(n);
        return object == null ? null : object.getClass();
    }

    default public boolean hasValue(@Nonnegative int n) {
        return this.getValue(n) != null;
    }

    default public boolean hasNoValue(@Nonnegative int n) {
        return this.getValue(n) == null;
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnegative int n) {
        return (T)GenericReflection.uncheckedCast((Object)this.getValue(n));
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnegative int n, @Nullable T t) {
        Object object = this.getValue(n);
        return (T)(object == null ? t : GenericReflection.uncheckedCast((Object)object));
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnegative int n, @Nonnull Class<T> clazz) {
        return clazz.cast(this.getValue(n));
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnegative int n, @Nullable T t, @Nonnull Class<T> clazz) {
        Object object = this.getValue(n);
        return object == null ? t : clazz.cast(object);
    }

    @Nullable
    default public <T> T getSafeCastedValue(@Nonnegative int n, @Nonnull Class<T> clazz) {
        return this.getSafeCastedValue(n, null, clazz);
    }

    default public void onSafeCastError(@Nonnegative int n, @Nonnull Class<?> clazz, @Nonnull Object object) {
    }

    @Nullable
    default public <T> T getSafeCastedValue(@Nonnegative int n, @Nullable T t, @Nonnull Class<T> clazz) {
        T t2;
        Object object = this.getValue(n);
        T t3 = t2 = object != null && clazz.isAssignableFrom(object.getClass()) ? clazz.cast(object) : t;
        if (t2 == null && object != null) {
            this.onSafeCastError(n, clazz, object);
        }
        return t2;
    }

    @Nullable
    default public <T> T getConvertedValue(@Nonnegative int n, @Nonnull Class<T> clazz) {
        return TypeConverter.convert(this.getValue(n), clazz);
    }

    @Nullable
    default public <T> T getConvertedValue(@Nonnegative int n, @Nullable T t, @Nonnull Class<T> clazz) {
        Object object = this.getValue(n);
        return object == null ? t : TypeConverter.convert(object, clazz, t);
    }

    default public boolean getAsBoolean(@Nonnegative int n) {
        return TypeConverter.convertToBoolean(this.getValue(n));
    }

    default public boolean getAsBoolean(@Nonnegative int n, boolean bl) {
        return TypeConverter.convertToBoolean(this.getValue(n), bl);
    }

    default public byte getAsByte(@Nonnegative int n) {
        return TypeConverter.convertToByte(this.getValue(n));
    }

    default public byte getAsByte(@Nonnegative int n, byte by) {
        return TypeConverter.convertToByte(this.getValue(n), by);
    }

    default public char getAsChar(@Nonnegative int n) {
        return TypeConverter.convertToChar(this.getValue(n));
    }

    default public char getAsChar(@Nonnegative int n, char c) {
        return TypeConverter.convertToChar(this.getValue(n), c);
    }

    default public double getAsDouble(@Nonnegative int n) {
        return TypeConverter.convertToDouble(this.getValue(n));
    }

    default public double getAsDouble(@Nonnegative int n, double d) {
        return TypeConverter.convertToDouble(this.getValue(n), d);
    }

    default public float getAsFloat(@Nonnegative int n) {
        return TypeConverter.convertToFloat(this.getValue(n));
    }

    default public float getAsFloat(@Nonnegative int n, float f) {
        return TypeConverter.convertToFloat(this.getValue(n), f);
    }

    default public int getAsInt(@Nonnegative int n) {
        return TypeConverter.convertToInt(this.getValue(n));
    }

    default public int getAsInt(@Nonnegative int n, int n2) {
        return TypeConverter.convertToInt(this.getValue(n), n2);
    }

    default public long getAsLong(@Nonnegative int n) {
        return TypeConverter.convertToLong(this.getValue(n));
    }

    default public long getAsLong(@Nonnegative int n, long l) {
        return TypeConverter.convertToLong(this.getValue(n), l);
    }

    default public short getAsShort(@Nonnegative int n) {
        return TypeConverter.convertToShort(this.getValue(n));
    }

    default public short getAsShort(@Nonnegative int n, short s) {
        return TypeConverter.convertToShort(this.getValue(n), s);
    }

    @Nullable
    default public String getAsString(@Nonnegative int n) {
        return this.getConvertedValue(n, null, String.class);
    }

    @Nullable
    default public String getAsString(@Nonnegative int n, @Nullable String string) {
        return this.getConvertedValue(n, string, String.class);
    }

    default public boolean hasStringValue(@Nonnegative int n, @Nullable String string) {
        return this.hasStringValue(n, string, false);
    }

    default public boolean hasStringValue(@Nonnegative int n, @Nullable String string, boolean bl) {
        String string2 = this.getAsString(n);
        return string2 == null ? bl : string2.equals(string);
    }

    @Nullable
    default public char[] getAsCharArray(@Nonnegative int n) {
        return this.getConvertedValue(n, null, char[].class);
    }

    @Nullable
    default public char[] getAsCharArray(@Nonnegative int n, @Nullable char[] cArray) {
        return this.getConvertedValue(n, cArray, char[].class);
    }

    @Nullable
    default public BigDecimal getAsBigDecimal(@Nonnegative int n) {
        return this.getConvertedValue(n, null, BigDecimal.class);
    }

    @Nullable
    default public BigDecimal getAsBigDecimal(@Nonnegative int n, @Nullable BigDecimal bigDecimal) {
        return this.getConvertedValue(n, bigDecimal, BigDecimal.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger(@Nonnegative int n) {
        return this.getConvertedValue(n, null, BigInteger.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger(@Nonnegative int n, @Nullable BigInteger bigInteger) {
        return this.getConvertedValue(n, bigInteger, BigInteger.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate(@Nonnegative int n) {
        return this.getConvertedValue(n, null, LocalDate.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate(@Nonnegative int n, @Nullable LocalDate localDate) {
        return this.getConvertedValue(n, localDate, LocalDate.class);
    }

    @Nullable
    default public LocalTime getAsLocalTime(@Nonnegative int n) {
        return this.getConvertedValue(n, null, LocalTime.class);
    }

    @Nullable
    default public LocalTime getAsLocalTime(@Nonnegative int n, @Nullable LocalTime localTime) {
        return this.getConvertedValue(n, localTime, LocalTime.class);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime(@Nonnegative int n) {
        return this.getConvertedValue(n, null, LocalDateTime.class);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime(@Nonnegative int n, @Nullable LocalDateTime localDateTime) {
        return this.getConvertedValue(n, localDateTime, LocalDateTime.class);
    }

    @Nullable
    default public byte[] getAsByteArray(@Nonnegative int n) {
        return this.getConvertedValue(n, null, byte[].class);
    }

    @Nullable
    default public Boolean getAsBooleanObj(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Boolean.class);
    }

    @Nullable
    default public Byte getAsByteObj(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Byte.class);
    }

    @Nullable
    default public Character getAsCharObj(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Character.class);
    }

    @Nullable
    default public Double getAsDoubleObj(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Double.class);
    }

    @Nullable
    default public Float getAsFloatObj(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Float.class);
    }

    @Nullable
    default public Integer getAsIntObj(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Integer.class);
    }

    @Nullable
    default public Long getAsLongObj(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Long.class);
    }

    @Nullable
    default public Short getAsShortObj(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Short.class);
    }

    @Nullable
    default public Blob getAsSqlBlob(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Blob.class);
    }

    @Nullable
    default public Clob getAsSqlClob(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Clob.class);
    }

    @Nullable
    default public Date getAsSqlDate(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Date.class);
    }

    @Nullable
    default public NClob getAsSqlNClob(@Nonnegative int n) {
        return this.getConvertedValue(n, null, NClob.class);
    }

    @Nullable
    default public RowId getAsSqlRowId(@Nonnegative int n) {
        return this.getConvertedValue(n, null, RowId.class);
    }

    @Nullable
    default public Time getAsSqlTime(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Time.class);
    }

    @Nullable
    default public Timestamp getAsSqlTimestamp(@Nonnegative int n) {
        return this.getConvertedValue(n, null, Timestamp.class);
    }

    @Nullable
    default public ICommonsList<String> getAsStringList(@Nonnegative int n) {
        return this.getAsStringList(n, null);
    }

    @Nullable
    default public ICommonsList<String> getAsStringList(@Nonnegative int n, @Nullable ICommonsList<String> iCommonsList) {
        Object object = this.getValue(n);
        if (object != null) {
            if (object instanceof String[]) {
                Object[] objectArray = (String[])object;
                return new CommonsArrayList(objectArray);
            }
            if (object instanceof String) {
                String string = (String)object;
                return new CommonsArrayList((Object)string);
            }
        }
        return iCommonsList;
    }

    @Nullable
    default public ICommonsOrderedSet<String> getAsStringSet(@Nonnegative int n) {
        return this.getAsStringSet(n, null);
    }

    @Nullable
    default public ICommonsOrderedSet<String> getAsStringSet(@Nonnegative int n, @Nullable ICommonsOrderedSet<String> iCommonsOrderedSet) {
        Object object = this.getValue(n);
        if (object != null) {
            if (object instanceof String[]) {
                Object[] objectArray = (String[])object;
                return new CommonsLinkedHashSet(objectArray);
            }
            if (object instanceof String) {
                String string = (String)object;
                return new CommonsLinkedHashSet((Object)string);
            }
        }
        return iCommonsOrderedSet;
    }
}

