/*
 * Decompiled with CFR 0.152.
 */
package com.helger.typeconvert.spi;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.IsSPIImplementation;
import com.helger.base.codec.base64.Base64;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsCopyOnWriteArrayList;
import com.helger.collection.commons.CommonsCopyOnWriteArraySet;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.CommonsLinkedList;
import com.helger.collection.commons.CommonsTreeSet;
import com.helger.collection.commons.CommonsVector;
import com.helger.collection.helper.PrimitiveCollectionHelper;
import com.helger.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.typeconvert.ITypeConverterRegistry;
import com.helger.typeconvert.impl.TypeConverter;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

@IsSPIImplementation
@Immutable
public final class CollectionTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(ArrayList.class, object -> {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return new CommonsArrayList(collection);
            }
            return new CommonsArrayList(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Vector.class, object -> {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return new CommonsVector(collection);
            }
            return new CommonsVector(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(LinkedList.class, object -> {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return new CommonsLinkedList(collection);
            }
            return new CommonsLinkedList(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(CopyOnWriteArrayList.class, object -> {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return new CommonsCopyOnWriteArrayList(collection);
            }
            return new CommonsCopyOnWriteArrayList(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(List.class, object -> {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return new CommonsArrayList(collection);
            }
            return new CommonsArrayList(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(TreeSet.class, object -> {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return new CommonsTreeSet(collection);
            }
            return new CommonsTreeSet(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(LinkedHashSet.class, object -> {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return new CommonsLinkedHashSet(collection);
            }
            return new CommonsLinkedHashSet(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(CopyOnWriteArraySet.class, object -> {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return new CommonsCopyOnWriteArraySet(collection);
            }
            return new CommonsCopyOnWriteArraySet(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Set.class, object -> {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return new CommonsHashSet(collection);
            }
            return new CommonsHashSet(object);
        });
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, CommonsArrayList.class, PrimitiveCollectionHelper::createPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, CommonsHashSet.class, PrimitiveCollectionHelper::createPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::createPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::createPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(byte[].class, String.class, Base64::encodeBytes);
        iTypeConverterRegistry.registerTypeConverter(String.class, byte[].class, Base64::safeDecode);
        iTypeConverterRegistry.registerTypeConverter(byte[].class, CommonsArrayList.class, PrimitiveCollectionHelper::createPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(byte[].class, CommonsHashSet.class, PrimitiveCollectionHelper::createPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(byte[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::createPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(byte[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::createPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(char[].class, String.class, String::new);
        iTypeConverterRegistry.registerTypeConverter(String.class, char[].class, String::toCharArray);
        iTypeConverterRegistry.registerTypeConverter(char[].class, CommonsArrayList.class, PrimitiveCollectionHelper::createPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(char[].class, CommonsHashSet.class, PrimitiveCollectionHelper::createPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(char[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::createPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(char[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::createPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(double[].class, CommonsArrayList.class, PrimitiveCollectionHelper::createPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(double[].class, CommonsHashSet.class, PrimitiveCollectionHelper::createPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(double[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::createPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(double[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::createPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(float[].class, CommonsArrayList.class, PrimitiveCollectionHelper::createPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(float[].class, CommonsHashSet.class, PrimitiveCollectionHelper::createPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(float[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::createPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(float[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::createPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(int[].class, CommonsArrayList.class, PrimitiveCollectionHelper::createPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(int[].class, CommonsHashSet.class, PrimitiveCollectionHelper::createPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(int[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::createPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(int[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::createPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(long[].class, CommonsArrayList.class, PrimitiveCollectionHelper::createPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(long[].class, CommonsHashSet.class, PrimitiveCollectionHelper::createPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(long[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::createPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(long[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::createPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(short[].class, CommonsArrayList.class, PrimitiveCollectionHelper::createPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(short[].class, CommonsHashSet.class, PrimitiveCollectionHelper::createPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(short[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::createPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(short[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::createPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(boolean[].class, object -> {
            boolean[] blArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    blArray[i] = TypeConverter.convertToBoolean(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                blArray = new boolean[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    blArray[n++] = TypeConverter.convertToBoolean(e);
                }
            } else {
                blArray = new boolean[]{TypeConverter.convertToBoolean(object)};
            }
            return blArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(byte[].class, object -> {
            byte[] byArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    byArray[i] = TypeConverter.convertToByte(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                byArray = new byte[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    byArray[n++] = TypeConverter.convertToByte(e);
                }
            } else {
                byArray = new byte[]{TypeConverter.convertToByte(object)};
            }
            return byArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(char[].class, object -> {
            char[] cArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                cArray = new char[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    cArray[i] = TypeConverter.convertToChar(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                cArray = new char[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    cArray[n++] = TypeConverter.convertToChar(e);
                }
            } else {
                cArray = new char[]{TypeConverter.convertToChar(object)};
            }
            return cArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(double[].class, object -> {
            double[] dArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    dArray[i] = TypeConverter.convertToDouble(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                dArray = new double[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    dArray[n++] = TypeConverter.convertToDouble(e);
                }
            } else {
                dArray = new double[]{TypeConverter.convertToDouble(object)};
            }
            return dArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(float[].class, object -> {
            float[] fArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    fArray[i] = TypeConverter.convertToFloat(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                fArray = new float[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    fArray[n++] = TypeConverter.convertToFloat(e);
                }
            } else {
                fArray = new float[]{TypeConverter.convertToFloat(object)};
            }
            return fArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(int[].class, object -> {
            int[] nArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    nArray[i] = TypeConverter.convertToInt(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                nArray = new int[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    nArray[n++] = TypeConverter.convertToInt(e);
                }
            } else {
                nArray = new int[]{TypeConverter.convertToInt(object)};
            }
            return nArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(long[].class, object -> {
            long[] lArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    lArray[i] = TypeConverter.convertToLong(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                lArray = new long[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    lArray[n++] = TypeConverter.convertToLong(e);
                }
            } else {
                lArray = new long[]{TypeConverter.convertToLong(object)};
            }
            return lArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(short[].class, object -> {
            short[] sArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    sArray[i] = TypeConverter.convertToShort(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                sArray = new short[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    sArray[n++] = TypeConverter.convertToShort(e);
                }
            } else {
                sArray = new short[]{TypeConverter.convertToShort(object)};
            }
            return sArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(String[].class, object -> {
            String[] stringArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    stringArray[i] = TypeConverter.convert(object2, String.class);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                stringArray = new String[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    stringArray[n++] = TypeConverter.convert(e, String.class);
                }
            } else {
                stringArray = new String[]{TypeConverter.convert(object, String.class)};
            }
            return stringArray;
        });
    }
}

