/*
 * Decompiled with CFR 0.152.
 */
package com.helger.typeconvert.spi;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.IsSPIImplementation;
import com.helger.base.reflection.GenericReflection;
import com.helger.base.string.StringParser;
import com.helger.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.typeconvert.ITypeConverterRegistry;
import com.helger.typeconvert.impl.TypeConverter;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IsSPIImplementation
@Immutable
public final class BaseTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTypeConverterRegistrar.class);

    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, Boolean.class, number -> number.intValue() != 0);
        iTypeConverterRegistry.registerTypeConverter(Character.class, Boolean.class, c -> c.charValue() != '\u0000');
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Boolean.class, object -> StringParser.parseBoolObj((Object)object, (Boolean)null));
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, Byte.class, number -> number.byteValue());
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Byte.class, bl -> bl != false ? (byte)1 : (byte)0);
        iTypeConverterRegistry.registerTypeConverter(Character.class, Byte.class, c -> (byte)c.charValue());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Byte.class, object -> StringParser.parseByteObj((Object)object, (Byte)null));
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, Character.class, number -> Character.valueOf((char)number.intValue()));
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Character.class, bl -> Character.valueOf(bl != false ? (char)'\u0001' : (char)'\u0000'));
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Character.class, object -> {
            String string = object.toString();
            return string.length() == 1 ? Character.valueOf(string.charAt(0)) : null;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, Double.class, number -> number.doubleValue());
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Double.class, bl -> bl != false ? 1.0 : 0.0);
        iTypeConverterRegistry.registerTypeConverter(Character.class, Double.class, c -> c.charValue());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Double.class, object -> StringParser.parseDoubleObj((Object)object, (Double)null));
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, Float.class, number -> Float.valueOf(number.floatValue()));
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Float.class, bl -> Float.valueOf(bl != false ? 1.0f : 0.0f));
        iTypeConverterRegistry.registerTypeConverter(Character.class, Float.class, c -> Float.valueOf(c.charValue()));
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Float.class, object -> StringParser.parseFloatObj((Object)object, (Float)null));
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, Integer.class, number -> number.intValue());
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Integer.class, bl -> bl != false ? 1 : 0);
        iTypeConverterRegistry.registerTypeConverter(Character.class, Integer.class, c -> c.charValue());
        iTypeConverterRegistry.registerTypeConverter(String.class, Integer.class, string -> {
            BigDecimal bigDecimal = StringParser.parseBigDecimal((String)string, (BigDecimal)null);
            return bigDecimal == null ? null : Integer.valueOf(bigDecimal.intValue());
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Integer.class, object -> StringParser.parseIntObj((Object)object, (Integer)null));
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, Long.class, number -> number.longValue());
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Long.class, bl -> bl != false ? 1L : 0L);
        iTypeConverterRegistry.registerTypeConverter(Character.class, Long.class, c -> c.charValue());
        iTypeConverterRegistry.registerTypeConverter(String.class, Long.class, string -> {
            BigDecimal bigDecimal = StringParser.parseBigDecimal((String)string, (BigDecimal)null);
            return bigDecimal == null ? null : Long.valueOf(bigDecimal.longValue());
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Long.class, object -> StringParser.parseLongObj((Object)object, (Long)null));
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, Short.class, number -> number.shortValue());
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Short.class, bl -> bl != false ? (short)1 : (short)0);
        iTypeConverterRegistry.registerTypeConverter(Character.class, Short.class, c -> (short)c.charValue());
        iTypeConverterRegistry.registerTypeConverter(String.class, Short.class, string -> {
            BigDecimal bigDecimal = StringParser.parseBigDecimal((String)string, (BigDecimal)null);
            return bigDecimal == null ? null : Short.valueOf(bigDecimal.shortValue());
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Short.class, object -> StringParser.parseShortObj((Object)object, (Short)null));
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(String.class, Object::toString);
        iTypeConverterRegistry.registerTypeConverter(BigInteger.class, BigDecimal.class, BigDecimal::new);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, BigDecimal.class, number -> BigDecimal.valueOf(number.doubleValue()));
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, BigDecimal.class, bl -> bl != false ? BigDecimal.ONE : BigDecimal.ZERO);
        iTypeConverterRegistry.registerTypeConverter(Character.class, BigDecimal.class, c -> BigDecimal.valueOf(c.charValue()));
        iTypeConverterRegistry.registerTypeConverter(Byte.class, BigDecimal.class, by -> BigDecimal.valueOf(by.intValue()));
        iTypeConverterRegistry.registerTypeConverter(Integer.class, BigDecimal.class, n -> BigDecimal.valueOf(n.intValue()));
        iTypeConverterRegistry.registerTypeConverter(Long.class, BigDecimal.class, l -> BigDecimal.valueOf(l));
        iTypeConverterRegistry.registerTypeConverter(Short.class, BigDecimal.class, s -> BigDecimal.valueOf(s.shortValue()));
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(BigDecimal.class, object -> StringParser.parseBigDecimal((String)object.toString(), (BigDecimal)null));
        iTypeConverterRegistry.registerTypeConverter(BigDecimal.class, BigInteger.class, BigDecimal::toBigInteger);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, BigInteger.class, number -> BigInteger.valueOf(number.longValue()));
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, BigInteger.class, bl -> bl != false ? BigInteger.ONE : BigInteger.ZERO);
        iTypeConverterRegistry.registerTypeConverter(Character.class, BigInteger.class, c -> BigInteger.valueOf(c.charValue()));
        iTypeConverterRegistry.registerTypeConverter(String.class, BigInteger.class, string -> {
            BigDecimal bigDecimal = StringParser.parseBigDecimal((String)string, (BigDecimal)null);
            return bigDecimal == null ? null : bigDecimal.toBigInteger();
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(BigInteger.class, object -> StringParser.parseBigInteger((String)object.toString(), (BigInteger)null));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(AtomicBoolean.class, atomicBoolean -> atomicBoolean.get());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(AtomicBoolean.class, object -> new AtomicBoolean(TypeConverter.convert(object, Boolean.class)));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(AtomicInteger.class, atomicInteger -> atomicInteger.get());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(AtomicInteger.class, object -> new AtomicInteger(TypeConverter.convert(object, Integer.class)));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(AtomicLong.class, atomicLong -> atomicLong.get());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(AtomicLong.class, object -> new AtomicLong(TypeConverter.convert(object, Long.class)));
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(StringBuilder.class, object -> {
            if (object instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)object;
                return new StringBuilder(charSequence);
            }
            return new StringBuilder(TypeConverter.convert(object, String.class));
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(StringBuffer.class, object -> {
            if (object instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)object;
                return new StringBuffer(charSequence);
            }
            return new StringBuffer(TypeConverter.convert(object, String.class));
        });
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(String[].class, stringArray -> {
            if (((String[])stringArray).length == 0) {
                return null;
            }
            if (((String[])stringArray).length > 1) {
                LOGGER.warn("An array with " + ((String[])stringArray).length + " items is present; using the first value: " + Arrays.toString(stringArray));
            }
            return stringArray[0];
        });
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Enum.class, String.class, enum_ -> enum_.getClass().getName() + ":" + enum_.name());
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAssignableDestination(String.class, Enum.class, string -> {
            String[] stringArray = string.split(":", 2);
            try {
                Class clazz = GenericReflection.getClassFromName((String)stringArray[0]);
                return Enum.valueOf(clazz, stringArray[1]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        });
    }
}

