/*
 * Decompiled with CFR 0.152.
 */
package com.helger.typeconvert.impl;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.typeconvert.ITypeConverterRule;
import com.helger.typeconvert.impl.AbstractTypeConverterRule;
import com.helger.typeconvert.impl.TypeConverter;
import jakarta.annotation.Nonnull;
import java.util.function.Function;

public class TypeConverterRuleFixedSourceAnyDestination<SRC>
extends AbstractTypeConverterRule<SRC, Object> {
    private final Class<SRC> m_aSrcClass;
    private final Function<? super SRC, ? extends Object> m_aInBetweenConverter;
    private Class<?> m_aEffectiveDstClass;

    public TypeConverterRuleFixedSourceAnyDestination(@Nonnull Class<SRC> clazz, @Nonnull Function<? super SRC, ? extends Object> function) {
        super(ITypeConverterRule.ESubType.FIXED_SRC_ANY_DST);
        this.m_aSrcClass = (Class)ValueEnforcer.notNull(clazz, (String)"SrcClass");
        this.m_aInBetweenConverter = (Function)ValueEnforcer.notNull(function, (String)"InBetweenConverter");
    }

    @Override
    public final boolean canConvert(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        if (!this.m_aSrcClass.equals(clazz)) {
            return false;
        }
        this.m_aEffectiveDstClass = clazz2;
        return true;
    }

    @Nonnull
    protected Object getInBetweenValue(@Nonnull SRC SRC) {
        return this.m_aInBetweenConverter.apply(SRC);
    }

    @Override
    public final Object apply(@Nonnull SRC SRC) {
        Object object = this.getInBetweenValue(SRC);
        return TypeConverter.convert(object, this.m_aEffectiveDstClass);
    }

    @Nonnull
    public final Class<?> getSourceClass() {
        return this.m_aSrcClass;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("SrcClass", this.m_aSrcClass).append("InBetweenConverter", this.m_aInBetweenConverter).getToString();
    }
}

