/*
 * Decompiled with CFR 0.152.
 */
package com.helger.typeconvert.impl;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.typeconvert.ITypeConverterRule;
import com.helger.typeconvert.impl.AbstractTypeConverterRule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Function;

public class TypeConverterRuleAssignableSourceFixedDestination<SRC, DST>
extends AbstractTypeConverterRule<SRC, DST> {
    private final Class<SRC> m_aSrcClass;
    private final Class<DST> m_aDstClass;
    private final Function<? super SRC, ? extends DST> m_aConverter;

    public TypeConverterRuleAssignableSourceFixedDestination(@Nonnull Class<SRC> clazz, @Nonnull Class<DST> clazz2, @Nonnull Function<? super SRC, ? extends DST> function) {
        super(ITypeConverterRule.ESubType.ASSIGNABLE_SRC_FIXED_DST);
        this.m_aSrcClass = (Class)ValueEnforcer.notNull(clazz, (String)"SrcClass");
        this.m_aDstClass = (Class)ValueEnforcer.notNull(clazz2, (String)"DestClass");
        this.m_aConverter = (Function)ValueEnforcer.notNull(function, (String)"Converter");
    }

    @Override
    public final boolean canConvert(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        return this.m_aDstClass.equals(clazz2) && this.m_aSrcClass.isAssignableFrom(clazz);
    }

    @Nonnull
    public final Class<SRC> getSourceClass() {
        return this.m_aSrcClass;
    }

    @Nonnull
    public final Class<DST> getDestinationClass() {
        return this.m_aDstClass;
    }

    @Override
    @Nullable
    public DST apply(@Nonnull SRC SRC) {
        return this.m_aConverter.apply(SRC);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("SrcClass", this.m_aSrcClass).append("DstClass", this.m_aDstClass).append("Converter", this.m_aConverter).getToString();
    }
}

