/*
 * Decompiled with CFR 0.152.
 */
package com.helger.typeconvert.impl;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.typeconvert.ITypeConverterRule;
import com.helger.typeconvert.impl.AbstractTypeConverterRule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Function;

public class TypeConverterRuleAnySourceFixedDestination<DST>
extends AbstractTypeConverterRule<Object, DST> {
    private final Class<DST> m_aDstClass;
    private final Function<? super Object, ? extends DST> m_aConverter;

    public TypeConverterRuleAnySourceFixedDestination(@Nonnull Class<DST> clazz, @Nonnull Function<? super Object, ? extends DST> function) {
        super(ITypeConverterRule.ESubType.ANY_SRC_FIXED_DST);
        this.m_aDstClass = (Class)ValueEnforcer.notNull(clazz, (String)"DestClass");
        this.m_aConverter = (Function)ValueEnforcer.notNull(function, (String)"Converter");
    }

    @Override
    public final boolean canConvert(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        return this.m_aDstClass.equals(clazz2);
    }

    @Nonnull
    public final Class<?> getDestinationClass() {
        return this.m_aDstClass;
    }

    @Override
    @Nullable
    public DST apply(@Nonnull Object object) {
        return this.m_aConverter.apply(object);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("DstClass", this.m_aDstClass).append("Converter", this.m_aConverter).getToString();
    }
}

