/*
 * Decompiled with CFR 0.152.
 */
package com.helger.typeconvert.collection;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.typeconvert.collection.AttributeContainer;
import com.helger.typeconvert.collection.IStringMap;
import com.helger.typeconvert.impl.TypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.function.Predicate;

@NotThreadSafe
public class StringMap
extends AttributeContainer<String, String>
implements IStringMap {
    public StringMap() {
    }

    public StringMap(@Nonnull Map<String, String> map) {
        super(map);
    }

    public StringMap(@Nonnull String string, @Nonnull String string2) {
        this.put(string, string2);
    }

    @Nonnull
    public final StringMap addIfNotNull(@Nonnull String string, @Nonnull Object object) {
        return this.addIfNotNull(string, TypeConverter.convert(object, String.class));
    }

    @Nonnull
    public final StringMap addIfNotNull(@Nonnull String string, @Nullable String string2) {
        super.putIfNotNull((Object)string, (Object)string2);
        return this;
    }

    @Nonnull
    public final StringMap addIf(@Nonnull String string, @Nullable String string2, @Nonnull Predicate<? super String> predicate) {
        super.putIf((Object)string, (Object)string2, predicate);
        return this;
    }

    @Nonnull
    public final StringMap add(@Nonnull String string, @Nonnull Object object) {
        return this.add(string, TypeConverter.convert(object, String.class));
    }

    @Nonnull
    public final StringMap add(@Nonnull String string, @Nullable String string2) {
        this.putIn(string, string2);
        return this;
    }

    @Nonnull
    public final StringMap add(@Nonnull String string, boolean bl) {
        return this.add(string, Boolean.toString(bl));
    }

    @Nonnull
    public final StringMap add(@Nonnull String string, int n) {
        return this.add(string, Integer.toString(n));
    }

    @Nonnull
    public final StringMap add(@Nonnull String string, long l) {
        return this.add(string, Long.toString(l));
    }

    @Nonnull
    public final StringMap addWithoutValue(@Nonnull String string) {
        return this.add(string, "");
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public StringMap getClone() {
        return new StringMap((Map<String, String>)((Object)this));
    }
}

