/*
 * Decompiled with CFR 0.152.
 */
package com.helger.typeconvert.collection;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.collection.commons.ICommonsMap;
import com.helger.typeconvert.collection.IAfterSetValueCallback;
import com.helger.typeconvert.collection.IBeforeSetValueCallback;
import com.helger.typeconvert.trait.IGetterByKeyTrait;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

public interface IAttributeContainer<KEYTYPE, VALUETYPE>
extends ICommonsMap<KEYTYPE, VALUETYPE>,
IGetterByKeyTrait<KEYTYPE> {
    @Override
    @Nullable
    default public VALUETYPE getValue(@Nullable KEYTYPE KEYTYPE) {
        return (VALUETYPE)this.get(KEYTYPE);
    }

    @Override
    default public int getAsInt(@Nullable KEYTYPE KEYTYPE) {
        return this.getAsInt(KEYTYPE, -1);
    }

    @Override
    default public long getAsLong(@Nullable KEYTYPE KEYTYPE) {
        return this.getAsLong(KEYTYPE, -1L);
    }

    @Override
    default public float getAsFloat(@Nullable KEYTYPE KEYTYPE) {
        return this.getAsFloat(KEYTYPE, -1.0f);
    }

    @Override
    default public double getAsDouble(@Nullable KEYTYPE KEYTYPE) {
        return this.getAsDouble(KEYTYPE, -1.0);
    }

    @Override
    default public boolean getAsBoolean(@Nullable KEYTYPE KEYTYPE) {
        return this.getAsBoolean(KEYTYPE, false);
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IBeforeSetValueCallback<KEYTYPE, VALUETYPE>> beforeSetValueCallbacks();

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IAfterSetValueCallback<KEYTYPE, VALUETYPE>> afterSetValueCallbacks();

    @Nonnull
    default public EChange putIn(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        if (this.beforeSetValueCallbacks().forEachBreakable(iBeforeSetValueCallback -> iBeforeSetValueCallback.beforeSetValue(KEYTYPE, VALUETYPE)).isBreak()) {
            return EChange.UNCHANGED;
        }
        Object object = this.put(KEYTYPE, VALUETYPE);
        if (EqualsHelper.equals(VALUETYPE, (Object)object)) {
            return EChange.UNCHANGED;
        }
        this.afterSetValueCallbacks().forEach(iAfterSetValueCallback -> iAfterSetValueCallback.afterSetValue(KEYTYPE, object, VALUETYPE));
        return EChange.CHANGED;
    }

    @Nonnull
    default public EChange putAllIn(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        EChange eChange = EChange.UNCHANGED;
        if (map != null) {
            for (Map.Entry<KEYTYPE, VALUETYPE> entry : map.entrySet()) {
                eChange = eChange.or((IChangeIndicator)this.putIn(entry.getKey(), entry.getValue()));
            }
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public IAttributeContainer<KEYTYPE, VALUETYPE> getClone();
}

