/*
 * Decompiled with CFR 0.152.
 */
package com.helger.typeconvert.collection;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsConcurrentHashMap;
import com.helger.typeconvert.collection.IAfterSetValueCallback;
import com.helger.typeconvert.collection.IAttributeContainer;
import com.helger.typeconvert.collection.IBeforeSetValueCallback;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

@ThreadSafe
public class AttributeContainerConcurrent<KEYTYPE, VALUETYPE>
extends CommonsConcurrentHashMap<KEYTYPE, VALUETYPE>
implements IAttributeContainer<KEYTYPE, VALUETYPE> {
    private final transient CallbackList<IBeforeSetValueCallback<KEYTYPE, VALUETYPE>> m_aBeforeCallbacks = new CallbackList();
    private final transient CallbackList<IAfterSetValueCallback<KEYTYPE, VALUETYPE>> m_aAfterCallbacks = new CallbackList();

    public AttributeContainerConcurrent() {
    }

    public AttributeContainerConcurrent(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        super(map);
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IBeforeSetValueCallback<KEYTYPE, VALUETYPE>> beforeSetValueCallbacks() {
        return this.m_aBeforeCallbacks;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IAfterSetValueCallback<KEYTYPE, VALUETYPE>> afterSetValueCallbacks() {
        return this.m_aAfterCallbacks;
    }

    public boolean containsKey(@Nullable Object object) {
        return object != null && super.containsKey(object);
    }

    @Nullable
    public VALUETYPE get(@Nullable Object object) {
        return (VALUETYPE)(object != null ? super.get(object) : null);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public AttributeContainerConcurrent<KEYTYPE, VALUETYPE> getClone() {
        return new AttributeContainerConcurrent<KEYTYPE, VALUETYPE>(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator((Object)this);
        for (Map.Entry entry : this.entrySet()) {
            hashCodeGenerator.append(entry.getKey()).append(entry.getValue());
        }
        return hashCodeGenerator.getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("BeforeCallbacks", this.m_aBeforeCallbacks).append("AfterCallbacks", this.m_aAfterCallbacks).getToString();
    }
}

