/*
 * Decompiled with CFR 0.152.
 */
package com.mohamedrejeb.ksoup.entities.text.translate;

import com.mohamedrejeb.ksoup.entities.text.translate.CodePointTranslator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u001c\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/mohamedrejeb/ksoup/entities/text/translate/NumericEntityEncoder;", "Lcom/mohamedrejeb/ksoup/entities/text/translate/CodePointTranslator;", "range", "Lkotlin/ranges/IntRange;", "between", "", "<init>", "(Lkotlin/ranges/IntRange;Z)V", "()V", "translate", "codePoint", "", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Companion", "ksoup-entities"})
public final class NumericEntityEncoder
extends CodePointTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntRange range;
    private final boolean between;

    private NumericEntityEncoder(IntRange range, boolean between) {
        this.range = range;
        this.between = between;
    }

    public NumericEntityEncoder() {
        this(new IntRange(0, Integer.MAX_VALUE), true);
    }

    @Override
    public boolean translate(int codePoint, @NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"stringBuilder");
        if (this.between != this.range.contains(codePoint)) {
            return false;
        }
        stringBuilder.append("&#");
        String string = Integer.toString(codePoint, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        stringBuilder.append(string);
        stringBuilder.append(';');
        return true;
    }

    public /* synthetic */ NumericEntityEncoder(IntRange range, boolean between, DefaultConstructorMarker $constructor_marker) {
        this(range, between);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lcom/mohamedrejeb/ksoup/entities/text/translate/NumericEntityEncoder$Companion;", "", "<init>", "()V", "above", "Lcom/mohamedrejeb/ksoup/entities/text/translate/NumericEntityEncoder;", "codePoint", "", "below", "between", "codePointLow", "codePointHigh", "outsideOf", "ksoup-entities"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NumericEntityEncoder above(int codePoint) {
            return this.outsideOf(0, codePoint);
        }

        @NotNull
        public final NumericEntityEncoder below(int codePoint) {
            return this.outsideOf(codePoint, Integer.MAX_VALUE);
        }

        @NotNull
        public final NumericEntityEncoder between(int codePointLow, int codePointHigh) {
            return new NumericEntityEncoder(new IntRange(codePointLow, codePointHigh), true, null);
        }

        @NotNull
        public final NumericEntityEncoder outsideOf(int codePointLow, int codePointHigh) {
            return new NumericEntityEncoder(new IntRange(codePointLow, codePointHigh), false, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

