/*
 * Decompiled with CFR 0.152.
 */
package com.mohamedrejeb.ksoup.entities.text.translate;

import com.mohamedrejeb.ksoup.entities.StringTranslator;
import com.mohamedrejeb.ksoup.entities.utils.CharsUtils;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/mohamedrejeb/ksoup/entities/text/translate/NumericEntityDecoder;", "Lcom/mohamedrejeb/ksoup/entities/StringTranslator;", "options", "", "Lcom/mohamedrejeb/ksoup/entities/text/translate/NumericEntityDecoder$Option;", "<init>", "([Lcom/mohamedrejeb/ksoup/entities/text/translate/NumericEntityDecoder$Option;)V", "", "isSet", "", "option", "translate", "", "input", "", "offset", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Option", "Companion", "ksoup-entities"})
@SourceDebugExtension(value={"SMAP\nNumericEntityDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumericEntityDecoder.kt\ncom/mohamedrejeb/ksoup/entities/text/translate/NumericEntityDecoder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,129:1\n13458#2,2:130\n*S KotlinDebug\n*F\n+ 1 NumericEntityDecoder.kt\ncom/mohamedrejeb/ksoup/entities/text/translate/NumericEntityDecoder\n*L\n112#1:130,2\n*E\n"})
public final class NumericEntityDecoder
extends StringTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Option> options;
    @NotNull
    private static final Set<Option> DEFAULT_OPTIONS = SetsKt.setOf((Object)((Object)Option.SemiColonRequired));

    public NumericEntityDecoder(Option ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options.length == 0 ? DEFAULT_OPTIONS : SetsKt.setOf((Object[])Arrays.copyOf(options, options.length));
    }

    private final boolean isSet(Option option) {
        return this.options.contains((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int translate(@NotNull String input, int offset, @NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"stringBuilder");
        int seqEnd = input.length();
        if (input.charAt(offset) == '&' && offset < seqEnd - 2 && input.charAt(offset + 1) == '#') {
            int n;
            boolean semiNext;
            int end;
            int start = offset + 2;
            boolean isHex = false;
            char firstChar = input.charAt(start);
            switch (firstChar) {
                case 'X': 
                case 'x': {
                    isHex = true;
                    if (++start != seqEnd) break;
                    return 0;
                }
            }
            for (end = start; end < seqEnd; ++end) {
                char c = input.charAt(end);
                if ('0' <= c ? c < ':' : false) continue;
                c = input.charAt(end);
                if ('a' <= c ? c < 'g' : false) continue;
                c = input.charAt(end);
                boolean bl = 'A' <= c ? c < 'G' : false;
                if (!bl) break;
            }
            boolean bl = semiNext = end != seqEnd && input.charAt(end) == ';';
            if (!semiNext) {
                if (this.isSet(Option.SemiColonRequired)) {
                    return 0;
                }
                if (this.isSet(Option.ErrorIfNoSemiColon)) {
                    throw new IllegalArgumentException("Semi-colon required at end of numeric entity");
                }
            }
            try {
                n = isHex ? Integer.parseInt(((Object)input.subSequence(start, end)).toString(), CharsKt.checkRadix((int)16)) : Integer.parseInt(((Object)input.subSequence(start, end)).toString(), CharsKt.checkRadix((int)10));
            }
            catch (NumberFormatException e) {
                return 0;
            }
            int entityValue = n;
            if (entityValue > 65535) {
                void $this$forEach$iv;
                char[] cArray = CharsUtils.INSTANCE.toChars(entityValue);
                boolean $i$f$forEach = false;
                int n2 = ((void)$this$forEach$iv).length;
                for (int i = 0; i < n2; ++i) {
                    void element$iv;
                    void it = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    stringBuilder.append((char)it);
                }
            } else {
                if (entityValue < 0 || entityValue > 65535) {
                    throw new IllegalArgumentException("Invalid Char code: " + entityValue);
                }
                stringBuilder.append((char)entityValue);
            }
            return 2 + end - start + (isHex ? 1 : 0) + (semiNext ? 1 : 0);
        }
        return 0;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/mohamedrejeb/ksoup/entities/text/translate/NumericEntityDecoder$Companion;", "", "<init>", "()V", "DEFAULT_OPTIONS", "", "Lcom/mohamedrejeb/ksoup/entities/text/translate/NumericEntityDecoder$Option;", "ksoup-entities"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/mohamedrejeb/ksoup/entities/text/translate/NumericEntityDecoder$Option;", "", "<init>", "(Ljava/lang/String;I)V", "SemiColonRequired", "SemiColonOptional", "ErrorIfNoSemiColon", "ksoup-entities"})
    public static final class Option
    extends Enum<Option> {
        public static final /* enum */ Option SemiColonRequired = new Option();
        public static final /* enum */ Option SemiColonOptional = new Option();
        public static final /* enum */ Option ErrorIfNoSemiColon = new Option();
        private static final /* synthetic */ Option[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Option[] values() {
            return (Option[])$VALUES.clone();
        }

        public static Option valueOf(String value) {
            return Enum.valueOf(Option.class, value);
        }

        @NotNull
        public static EnumEntries<Option> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = optionArray = new Option[]{Option.SemiColonRequired, Option.SemiColonOptional, Option.ErrorIfNoSemiColon};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

