/*
 * Decompiled with CFR 0.152.
 */
package com.mohamedrejeb.ksoup.entities;

import com.mohamedrejeb.ksoup.entities.StringTranslator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\r2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/mohamedrejeb/ksoup/entities/LookupTranslator;", "Lcom/mohamedrejeb/ksoup/entities/StringTranslator;", "lookupMap", "", "Lkotlin/Pair;", "", "<init>", "(Ljava/util/List;)V", "", "prefixSet", "", "Lkotlin/UShort;", "shortest", "", "longest", "translate", "input", "offset", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ksoup-entities"})
public final class LookupTranslator
extends StringTranslator {
    @NotNull
    private final Map<String, String> lookupMap;
    @NotNull
    private final Set<UShort> prefixSet;
    private final int shortest;
    private final int longest;

    public LookupTranslator(@NotNull List<Pair<String, String>> lookupMap) {
        Intrinsics.checkNotNullParameter(lookupMap, (String)"lookupMap");
        this.lookupMap = new LinkedHashMap();
        this.prefixSet = new LinkedHashSet();
        int currentShortest = Integer.MAX_VALUE;
        int currentLongest = 0;
        for (Pair<String, String> pair : lookupMap) {
            String key = (String)pair.component1();
            String value = (String)pair.component2();
            this.lookupMap.put(key, value);
            this.prefixSet.add(UShort.box-impl((short)UShort.constructor-impl((short)((short)key.charAt(0)))));
            int sz = key.length();
            if (sz < currentShortest) {
                currentShortest = sz;
            }
            if (sz <= currentLongest) continue;
            currentLongest = sz;
        }
        this.shortest = currentShortest;
        this.longest = currentLongest;
    }

    @Override
    public int translate(@NotNull String input, int offset, @NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"stringBuilder");
        if (this.prefixSet.contains(UShort.box-impl((short)UShort.constructor-impl((short)((short)input.charAt(offset)))))) {
            int i;
            int n;
            int max = this.longest;
            if (offset + this.longest > input.length()) {
                max = input.length() - offset;
            }
            if ((n = this.shortest) <= (i = max)) {
                while (true) {
                    CharSequence subSeq;
                    String result;
                    if ((result = this.lookupMap.get(((Object)(subSeq = input.subSequence(offset, offset + i))).toString())) != null) {
                        stringBuilder.append(result);
                        return subSeq.length();
                    }
                    if (i == n) break;
                    --i;
                }
            }
        }
        return 0;
    }
}

