/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resource.wrapped;

import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.wrapped.AbstractWrappedReadableResource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class GZIPReadableResource
extends AbstractWrappedReadableResource {
    public GZIPReadableResource(@Nonnull IReadableResource iReadableResource) {
        super(iReadableResource);
    }

    @Nullable
    public InputStream getInputStream() {
        InputStream inputStream = this.getWrappedReadableResource().getInputStream();
        if (inputStream == null) {
            return null;
        }
        try {
            return new GZIPInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to open GZIP InputStream", iOException);
        }
    }

    @Override
    @Nonnull
    public GZIPReadableResource getReadableCloneForPath(@Nonnull String string) {
        return new GZIPReadableResource(this.getWrappedReadableResource().getReadableCloneForPath(string));
    }
}

