/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.relative;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.file.FileHelper;
import com.helger.io.file.FilenameHelper;
import com.helger.io.relative.IPathRelativeIO;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resourceresolver.DefaultResourceResolver;
import jakarta.annotation.Nonnull;
import java.io.File;

@Immutable
public class PathRelativeIO
implements IPathRelativeIO {
    private final String m_sBasePath;
    private final String m_sBaseURL;

    public PathRelativeIO(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"BasePath");
        this.m_sBasePath = string;
        String string2 = null;
        File file = new File(string);
        if (file.exists()) {
            string2 = FileHelper.getAsURLString(file);
        }
        this.m_sBaseURL = string2 != null ? string2 : string;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getBasePath() {
        return this.m_sBasePath;
    }

    @Nonnull
    @Nonempty
    public String getBaseURL() {
        return this.m_sBaseURL;
    }

    @Override
    @Nonnull
    public IReadableResource getResource(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RelativePath");
        String string2 = FilenameHelper.startsWithPathSeparatorChar(string) ? string.substring(1) : string;
        return DefaultResourceResolver.getResolvedResource(string2, this.m_sBaseURL);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PathRelativeIO pathRelativeIO = (PathRelativeIO)object;
        return this.m_sBasePath.equals(pathRelativeIO.m_sBasePath);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sBasePath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BasePath", (Object)this.m_sBasePath).append("BaseURL", (Object)this.m_sBaseURL).getToString();
    }
}

