/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.provider;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.EAppend;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.file.FileHelper;
import com.helger.io.provider.IInputStreamProvider;
import com.helger.io.provider.IOutputStreamProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

@Immutable
public class FileSystemByteStreamProvider
implements IInputStreamProvider,
IOutputStreamProvider {
    private final File m_aBasePath;

    public FileSystemByteStreamProvider(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemByteStreamProvider(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"BasePath");
        ValueEnforcer.isTrue((boolean)file.exists(), () -> "Base path does not exist: " + String.valueOf(file));
        ValueEnforcer.isTrue((boolean)file.isDirectory(), () -> "Only directories are allowed as base path: " + String.valueOf(file));
        this.m_aBasePath = file;
    }

    @Nonnull
    public File getBasePath() {
        return this.m_aBasePath;
    }

    @Override
    @Nullable
    public InputStream getInputStream(@Nonnull String string) {
        return FileHelper.getInputStream(new File(this.m_aBasePath, string));
    }

    @Override
    @Nullable
    public OutputStream getOutputStream(@Nonnull String string, @Nonnull EAppend eAppend) {
        return FileHelper.getOutputStream(new File(this.m_aBasePath, string), eAppend);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileSystemByteStreamProvider fileSystemByteStreamProvider = (FileSystemByteStreamProvider)object;
        return this.m_aBasePath.equals(fileSystemByteStreamProvider.m_aBasePath);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aBasePath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("basePath", (Object)this.m_aBasePath).getToString();
    }
}

