/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.charset.internal;

import com.fleeksoft.charset.Charsets;
import com.fleeksoft.charset.internal.CharsetNameMapping;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/fleeksoft/charset/internal/CharsetLookup;", "", "<init>", "()V", "", "charsetName", "Ljava/nio/charset/Charset;", "Lcom/fleeksoft/charset/Charset;", "forName", "(Ljava/lang/String;)Ljava/nio/charset/Charset;", "", "isSupported", "(Ljava/lang/String;)Z", "charset"})
@SourceDebugExtension(value={"SMAP\nCharsetLookup.jvmAndAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharsetLookup.jvmAndAndroid.kt\ncom/fleeksoft/charset/internal/CharsetLookup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,24:1\n1#2:25\n*E\n"})
public final class CharsetLookup {
    @NotNull
    public static final CharsetLookup INSTANCE = new CharsetLookup();

    private CharsetLookup() {
    }

    @NotNull
    public final Charset forName(@NotNull String charsetName) {
        Intrinsics.checkNotNullParameter((Object)charsetName, (String)"charsetName");
        String normalizedKey = Charsets.INSTANCE.normalizeCharsetName(charsetName);
        String string = CharsetNameMapping.INSTANCE.getStandardCharsetMapKeys().get(normalizedKey);
        if (string == null && (string = CharsetNameMapping.INSTANCE.getExtendedCharsetMapKeys().get(normalizedKey)) == null) {
            string = charsetName;
        }
        String charsetKey = string;
        Charset charset = Charset.forName(charsetKey);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        return charset;
    }

    public final boolean isSupported(@NotNull String charsetName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)charsetName, (String)"charsetName");
        String normalizedKey = Charsets.INSTANCE.normalizeCharsetName(charsetName);
        String string = CharsetNameMapping.INSTANCE.getStandardCharsetMapKeys().get(normalizedKey);
        if (string == null && (string = CharsetNameMapping.INSTANCE.getExtendedCharsetMapKeys().get(normalizedKey)) == null) {
            string = charsetName;
        }
        String charsetKey = string;
        Object object2 = this;
        try {
            CharsetLookup $this$isSupported_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Charset.isSupported(charsetKey));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }
}

