/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.charset;

import com.fleeksoft.charset.internal.CharsetLookup;
import java.nio.charset.Charset;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\n\u001a\u00060\bj\u0002`\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0014\u001a\u00060\bj\u0002`\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0017\u001a\u00060\bj\u0002`\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0011\u001a\u0004\b\u0016\u0010\u0013R\u001f\u0010\u001a\u001a\u00060\bj\u0002`\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0019\u0010\u0013R\u001f\u0010\u001d\u001a\u00060\bj\u0002`\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0011\u001a\u0004\b\u001c\u0010\u0013R\u001f\u0010 \u001a\u00060\bj\u0002`\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0011\u001a\u0004\b\u001f\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/fleeksoft/charset/Charsets;", "", "<init>", "()V", "", "name", "normalizeCharsetName", "(Ljava/lang/String;)Ljava/lang/String;", "Ljava/nio/charset/Charset;", "Lcom/fleeksoft/charset/Charset;", "forName", "(Ljava/lang/String;)Ljava/nio/charset/Charset;", "charsetName", "", "isSupported", "(Ljava/lang/String;)Z", "UTF8$delegate", "Lkotlin/Lazy;", "getUTF8", "()Ljava/nio/charset/Charset;", "UTF8", "US_ASCII$delegate", "getUS_ASCII", "US_ASCII", "ISO_8859_1$delegate", "getISO_8859_1", "ISO_8859_1", "UTF_16$delegate", "getUTF_16", "UTF_16", "UTF_32$delegate", "getUTF_32", "UTF_32", "charset"})
public final class Charsets {
    @NotNull
    public static final Charsets INSTANCE = new Charsets();
    @NotNull
    private static final Lazy UTF8$delegate = LazyKt.lazy(Charsets::UTF8_delegate$lambda$0);
    @NotNull
    private static final Lazy US_ASCII$delegate = LazyKt.lazy(Charsets::US_ASCII_delegate$lambda$1);
    @NotNull
    private static final Lazy ISO_8859_1$delegate = LazyKt.lazy(Charsets::ISO_8859_1_delegate$lambda$2);
    @NotNull
    private static final Lazy UTF_16$delegate = LazyKt.lazy(Charsets::UTF_16_delegate$lambda$3);
    @NotNull
    private static final Lazy UTF_32$delegate = LazyKt.lazy(Charsets::UTF_32_delegate$lambda$4);

    private Charsets() {
    }

    @NotNull
    public final Charset getUTF8() {
        Lazy lazy = UTF8$delegate;
        return (Charset)lazy.getValue();
    }

    @NotNull
    public final Charset getUS_ASCII() {
        Lazy lazy = US_ASCII$delegate;
        return (Charset)lazy.getValue();
    }

    @NotNull
    public final Charset getISO_8859_1() {
        Lazy lazy = ISO_8859_1$delegate;
        return (Charset)lazy.getValue();
    }

    @NotNull
    public final Charset getUTF_16() {
        Lazy lazy = UTF_16$delegate;
        return (Charset)lazy.getValue();
    }

    @NotNull
    public final Charset getUTF_32() {
        Lazy lazy = UTF_32$delegate;
        return (Charset)lazy.getValue();
    }

    @NotNull
    public final String normalizeCharsetName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = StringsKt.replace$default((String)StringsKt.replace$default((String)name, (String)"-", (String)"", (boolean)false, (int)4, null), (String)"_", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    @NotNull
    public final Charset forName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return CharsetLookup.INSTANCE.forName(name);
    }

    public final boolean isSupported(@NotNull String charsetName) {
        Intrinsics.checkNotNullParameter((Object)charsetName, (String)"charsetName");
        return CharsetLookup.INSTANCE.isSupported(charsetName);
    }

    private static final Charset UTF8_delegate$lambda$0() {
        return INSTANCE.forName("UTF-8");
    }

    private static final Charset US_ASCII_delegate$lambda$1() {
        return INSTANCE.forName("US-ASCII");
    }

    private static final Charset ISO_8859_1_delegate$lambda$2() {
        return INSTANCE.forName("ISO-8859-1");
    }

    private static final Charset UTF_16_delegate$lambda$3() {
        return INSTANCE.forName("UTF-16");
    }

    private static final Charset UTF_32_delegate$lambda$4() {
        return INSTANCE.forName("UTF-32");
    }
}

