/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class CSSReaderSettings
implements ICloneable<CSSReaderSettings> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    public static final boolean DEFAULT_BROWSER_COMPLIANT_MODE = false;
    public static final boolean DEFAULT_KEEP_DEPRECATED_PROPERTIES = false;
    public static final boolean DEFAULT_USE_SOURCE_LOCATION = true;
    public static final int DEFAULT_TAB_SIZE = 8;
    private Charset m_aFallbackCharset = DEFAULT_CHARSET;
    private ICSSParseErrorHandler m_aCustomErrorHandler;
    private ICSSParseExceptionCallback m_aCustomExceptionHandler;
    private boolean m_bBrowserCompliantMode = false;
    private boolean m_bKeepDeprecatedProperties = false;
    private boolean m_bUseSourceLocation = true;
    private int m_nTabSize = 8;
    private ICSSInterpretErrorHandler m_aInterpretErrorHandler;

    public CSSReaderSettings() {
    }

    public CSSReaderSettings(@Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)cSSReaderSettings, (String)"Other");
        this.m_aFallbackCharset = cSSReaderSettings.m_aFallbackCharset;
        this.m_aCustomErrorHandler = cSSReaderSettings.m_aCustomErrorHandler;
        this.m_aCustomExceptionHandler = cSSReaderSettings.m_aCustomExceptionHandler;
        this.m_bBrowserCompliantMode = cSSReaderSettings.m_bBrowserCompliantMode;
        this.m_bKeepDeprecatedProperties = cSSReaderSettings.m_bKeepDeprecatedProperties;
        this.m_bUseSourceLocation = cSSReaderSettings.m_bUseSourceLocation;
        this.m_nTabSize = cSSReaderSettings.m_nTabSize;
        this.m_aInterpretErrorHandler = cSSReaderSettings.m_aInterpretErrorHandler;
    }

    @Nonnull
    public Charset getFallbackCharset() {
        return this.m_aFallbackCharset;
    }

    @Nonnull
    public String getFallbackCharsetName() {
        return this.m_aFallbackCharset.name();
    }

    @Nonnull
    public CSSReaderSettings setFallbackCharset(@Nonnull @Nonempty Charset charset) {
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        this.m_aFallbackCharset = charset;
        return this;
    }

    @Nullable
    public ICSSParseErrorHandler getCustomErrorHandler() {
        return this.m_aCustomErrorHandler;
    }

    @Nonnull
    public CSSReaderSettings setCustomErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        this.m_aCustomErrorHandler = iCSSParseErrorHandler;
        return this;
    }

    @Nullable
    public ICSSParseExceptionCallback getCustomExceptionHandler() {
        return this.m_aCustomExceptionHandler;
    }

    @Nonnull
    public CSSReaderSettings setCustomExceptionHandler(@Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        this.m_aCustomExceptionHandler = iCSSParseExceptionCallback;
        return this;
    }

    public boolean isBrowserCompliantMode() {
        return this.m_bBrowserCompliantMode;
    }

    @Nonnull
    public CSSReaderSettings setBrowserCompliantMode(boolean bl) {
        this.m_bBrowserCompliantMode = bl;
        return this;
    }

    public boolean isKeepDeprecatedProperties() {
        return this.m_bKeepDeprecatedProperties;
    }

    @Nonnull
    public CSSReaderSettings setKeepDeprecatedProperties(boolean bl) {
        this.m_bKeepDeprecatedProperties = bl;
        return this;
    }

    public boolean isUseSourceLocation() {
        return this.m_bUseSourceLocation;
    }

    @Nonnull
    public CSSReaderSettings setUseSourceLocation(boolean bl) {
        this.m_bUseSourceLocation = bl;
        return this;
    }

    @Nonnegative
    public int getTabSize() {
        return this.m_nTabSize;
    }

    @Nonnull
    public CSSReaderSettings setTabSize(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"TabSize");
        this.m_nTabSize = n;
        return this;
    }

    @Nullable
    public ICSSInterpretErrorHandler getInterpretErrorHandler() {
        return this.m_aInterpretErrorHandler;
    }

    @Nonnull
    public CSSReaderSettings setInterpretErrorHandler(@Nullable ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        this.m_aInterpretErrorHandler = iCSSInterpretErrorHandler;
        return this;
    }

    @Nonnull
    public CSSReaderSettings getClone() {
        return new CSSReaderSettings(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("FallbackCharset", (Object)this.m_aFallbackCharset).append("CustomErrorHandler", (Object)this.m_aCustomErrorHandler).append("CustomExceptionHandler", (Object)this.m_aCustomExceptionHandler).append("BrowserCompliantMode", this.m_bBrowserCompliantMode).append("UseSourceLocation", this.m_bUseSourceLocation).append("TabSize", this.m_nTabSize).append("InterpretErrorHandler", (Object)this.m_aInterpretErrorHandler).getToString();
    }
}

